/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.support.ToBytesCodec;
import io.basc.framework.io.JavaSerializer;
import io.basc.framework.io.Serializer;
import io.basc.framework.io.SerializerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerializerCodec<T>
implements ToBytesCodec<T> {
    public static final SerializerCodec<Object> DEFAULT = new SerializerCodec(SerializerUtils.getSerializer());
    public static final SerializerCodec<Object> JAVA = new SerializerCodec(JavaSerializer.INSTANCE);
    private final Serializer serializer;

    public SerializerCodec(Serializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public byte[] encode(T source) throws EncodeException {
        return this.serializer.serialize(source);
    }

    @Override
    public T decode(InputStream source, int bufferSize) throws IOException, DecodeException {
        try {
            return this.serializer.deserialize(source);
        }
        catch (ClassNotFoundException e) {
            throw new DecodeException(e);
        }
    }

    @Override
    public void encode(T source, OutputStream target) throws IOException, EncodeException {
        this.serializer.serialize(source, target);
    }
}

