/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.support.CryptoCodec;
import io.basc.framework.util.StringUtils;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class SymmetricCodec
extends CryptoCodec {
    public static final String WORK_MODE = "CBC";
    public static final String FILL_STYLE = "PKCS5Padding";
    public static final String NO_PADDING = "NoPadding";

    public SymmetricCodec(String algorithm, String fillStyle, byte[] secretKey, AlgorithmParameterSpec algorithmParameterSpec) {
        this(algorithm, WORK_MODE, fillStyle, secretKey, algorithmParameterSpec);
    }

    public SymmetricCodec(String algorithm, String fillStyle, byte[] secretKey, byte[] ivKey) {
        this(algorithm, WORK_MODE, fillStyle, secretKey, ivKey);
    }

    public SymmetricCodec(String algorithm, String workMode, String fillStyle, byte[] secretKey, byte[] ivKey) {
        this(algorithm, workMode, fillStyle, secretKey, ivKey == null ? null : new IvParameterSpec(ivKey));
    }

    public SymmetricCodec(String algorithm, String workMode, String fillStyle, byte[] secretKey, AlgorithmParameterSpec algorithmParameterSpec) {
        super(algorithm + "/" + (StringUtils.isEmpty(workMode) ? WORK_MODE : workMode) + "/" + (StringUtils.isEmpty(fillStyle) ? FILL_STYLE : fillStyle), SymmetricCodec.getSecretKey(algorithm, secretKey), algorithmParameterSpec, null);
    }

    protected SymmetricCodec(SymmetricCodec codec) {
        super(codec);
    }

    @Override
    public SymmetricCodec clone() {
        return new SymmetricCodec(this);
    }
}

