/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.support.BytesCodec;
import io.basc.framework.io.FileUtils;
import io.basc.framework.io.IOUtils;
import io.basc.framework.util.Assert;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zip
implements BytesCodec {
    public static final Zip DEFAULT = new Zip();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(File source, File target) throws ZipException, IOException {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(target != null, "target");
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(source);
            if (!target.exists()) {
                target.mkdirs();
            }
            Enumeration<? extends ZipEntry> ens = zipFile.entries();
            ZipEntry zipEntry = null;
            while (ens.hasMoreElements()) {
                zipEntry = ens.nextElement();
                File f = new File(target, Assert.secureFilePath(zipEntry.getName()));
                if (zipEntry.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.createNewFile();
                InputStream is = zipFile.getInputStream(zipEntry);
                try {
                    FileUtils.copyInputStreamToFile(is, f);
                }
                finally {
                    IOUtils.close((Closeable)is);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(zipFile);
            throw throwable;
        }
        IOUtils.close((Closeable)zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void encode(InputStream source, int bufferSize, OutputStream target) throws IOException, EncodeException {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(target != null, "target");
        if (target instanceof ZipOutputStream) {
            IOUtils.write(source, target, bufferSize);
            return;
        }
        ZipOutputStream zip = null;
        try {
            zip = new ZipOutputStream(target);
            IOUtils.write(source, (OutputStream)zip, bufferSize);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zip);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)zip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decode(InputStream source, int bufferSize, OutputStream target) throws DecodeException, IOException {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(target != null, "target");
        if (source instanceof ZipInputStream) {
            IOUtils.write(source, target, bufferSize);
            return;
        }
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(source);
            IOUtils.write(zip, target, bufferSize);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zip);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)zip);
    }
}

