/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert;

import io.basc.framework.convert.Converter;
import io.basc.framework.convert.Inverter;
import io.basc.framework.convert.Mapper;
import io.basc.framework.convert.ReverseTransformer;
import io.basc.framework.convert.ReversibleConverter;
import io.basc.framework.convert.ReversibleMapper;
import io.basc.framework.convert.ReversibleMapperFactory;
import io.basc.framework.convert.ReversibleTransformer;
import io.basc.framework.convert.Transformer;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.comparator.TypeComparator;
import java.util.Map;
import java.util.TreeMap;

public class ConversionFactory<S, E extends Throwable>
implements ReversibleMapperFactory<S, E> {
    private Map<Class<?>, Converter<S, ?, ? extends E>> converterMap;
    private Map<Class<?>, Inverter<?, ? extends S, ? extends E>> inverterMap;
    private Map<Class<?>, Mapper<S, ?, ? extends E>> mapperMap;
    private Map<Class<?>, ReverseTransformer<?, ? extends S, ? extends E>> reverseTransformerMap;
    private Map<Class<?>, ReversibleConverter<S, ?, ? extends E>> reversibleConverterMap;
    private Map<Class<?>, ReversibleMapper<S, ?, ? extends E>> reversibleMapperMapper;
    private Map<Class<?>, ReversibleTransformer<S, ?, ? extends E>> reversibleTransformerMap;
    private Map<Class<?>, Transformer<S, ?, ? extends E>> transformerMap;

    @Override
    public final <R> R convert(S source, Class<? extends R> targetType) throws E {
        return ReversibleMapperFactory.super.convert(source, targetType);
    }

    @Override
    public final <R> R convert(S source, Class<? extends S> sourceType, Class<? extends R> targetType) throws E {
        return ReversibleMapperFactory.super.convert(source, sourceType, targetType);
    }

    @Override
    public final <R> R convert(S source, Class<? extends S> sourceType, TypeDescriptor targetType) throws E {
        return ReversibleMapperFactory.super.convert(source, sourceType, targetType);
    }

    @Override
    public final Object convert(S source, TypeDescriptor targetType) throws E {
        return ReversibleMapperFactory.super.convert(source, targetType);
    }

    @Override
    public final <R> R convert(S source, TypeDescriptor sourceType, Class<? extends R> targetType) throws E {
        return ReversibleMapperFactory.super.convert(source, sourceType, targetType);
    }

    private <T> T get(Class<?> type, Map<Class<?>, ?> sourceMap) {
        Object target;
        block2: {
            if (sourceMap == null || sourceMap.isEmpty()) {
                return null;
            }
            target = sourceMap.get(type);
            if (target != null) break block2;
            for (Map.Entry<Class<?>, ?> entry : sourceMap.entrySet()) {
                if (ClassUtils.isAssignable(entry.getKey(), type) && (target = entry.getValue()) != null) break;
            }
        }
        return (T)target;
    }

    @Override
    public <T> Converter<S, T, E> getConverter(Class<? extends T> type) {
        ReversibleConverter<S, ? extends T, E> converter = (ReversibleConverter<S, ? extends T, E>)this.get(type, this.converterMap);
        if (converter != null) {
            return converter;
        }
        converter = this.getReversibleConverter(type);
        if (converter != null) {
            return converter;
        }
        return this.getMapper(type);
    }

    @Override
    public <R> Inverter<R, S, E> getInverter(Class<? extends R> type) {
        Inverter inverter = (Inverter)this.get(type, this.inverterMap);
        if (inverter != null) {
            return inverter;
        }
        return this.getReversibleConverter(type);
    }

    @Override
    public <T> Mapper<S, T, E> getMapper(Class<? extends T> type) {
        Mapper mapper = (Mapper)this.get(type, this.mapperMap);
        if (mapper != null) {
            return mapper;
        }
        return this.getReversibleMapper(type);
    }

    @Override
    public <R> ReverseTransformer<R, S, E> getReverseTransformer(Class<? extends R> type) {
        ReverseTransformer reverseTransformer = (ReverseTransformer)this.get(type, this.reverseTransformerMap);
        if (reverseTransformer != null) {
            return reverseTransformer;
        }
        return this.getReversibleTransformer(type);
    }

    @Override
    public <T> ReversibleConverter<S, T, E> getReversibleConverter(Class<? extends T> type) {
        ReversibleConverter reversibleConverter = (ReversibleConverter)this.get(type, this.reversibleConverterMap);
        if (reversibleConverter != null) {
            return reversibleConverter;
        }
        return this.getReversibleMapper(type);
    }

    @Override
    public <T> ReversibleMapper<S, T, E> getReversibleMapper(Class<? extends T> type) {
        return (ReversibleMapper)this.get(type, this.reversibleMapperMapper);
    }

    @Override
    public <R> ReversibleTransformer<S, R, E> getReversibleTransformer(Class<? extends R> type) {
        ReversibleTransformer reversibleTransformer = (ReversibleTransformer)this.get(type, this.reversibleTransformerMap);
        if (reversibleTransformer != null) {
            return reversibleTransformer;
        }
        return this.getReversibleMapper(type);
    }

    @Override
    public <T> Transformer<S, T, E> getTransformer(Class<? extends T> type) {
        ReversibleTransformer<S, ? extends T, E> transformer = (ReversibleTransformer<S, ? extends T, E>)this.get(type, this.transformerMap);
        if (transformer != null) {
            return transformer;
        }
        transformer = this.getReversibleTransformer((Class)type);
        if (transformer != null) {
            return transformer;
        }
        return this.getMapper(type);
    }

    @Override
    public final <R extends S> R invert(Object source, Class<? extends Object> sourceType, Class<? extends R> targetType) throws E {
        return ReversibleMapperFactory.super.invert(source, sourceType, targetType);
    }

    @Override
    public final <R extends S> R invert(Object source, Class<? extends Object> sourceType, TypeDescriptor targetType) throws E {
        return ReversibleMapperFactory.super.invert(source, sourceType, targetType);
    }

    @Override
    public final <R extends S> R invert(Object source, Class<? extends R> targetType) throws E {
        return ReversibleMapperFactory.super.invert(source, targetType);
    }

    @Override
    public final S invert(Object source, TypeDescriptor targetType) throws E {
        return (S)ReversibleMapperFactory.super.invert(source, targetType);
    }

    @Override
    public final <R extends S> R invert(Object source, TypeDescriptor sourceType, Class<? extends R> targetType) throws E {
        return ReversibleMapperFactory.super.invert(source, sourceType, targetType);
    }

    private <T> Map<Class<?>, T> register(Class<?> type, T conversion, Map<Class<?>, T> sourceMap) {
        Assert.requiredArgument(type != null, "type");
        if (conversion == null) {
            if (sourceMap != null) {
                sourceMap.remove(type);
            }
        } else {
            if (sourceMap == null) {
                sourceMap = new TreeMap(TypeComparator.DEFAULT);
            }
            sourceMap.put(type, conversion);
        }
        return sourceMap;
    }

    @Override
    public <T> void registerConverter(Class<T> type, Converter<S, ? extends T, ? extends E> converter) {
        this.converterMap = this.register(type, converter, this.converterMap);
    }

    @Override
    public <R> void registerInverter(Class<R> type, Inverter<R, ? extends S, ? extends E> inverter) {
        this.inverterMap = this.register(type, inverter, this.inverterMap);
    }

    @Override
    public <T> void registerMapper(Class<T> type, Mapper<S, T, ? extends E> mapper) {
        this.mapperMap = this.register(type, mapper, this.mapperMap);
    }

    @Override
    public <R> void registerReverseTransformer(Class<R> type, ReverseTransformer<R, S, ? extends E> reverseTransformer) {
        this.reverseTransformerMap = this.register(type, reverseTransformer, this.reverseTransformerMap);
    }

    @Override
    public <T> void registerReversibleConverter(Class<T> type, ReversibleConverter<S, T, ? extends E> converter) {
        this.reversibleConverterMap = this.register(type, converter, this.reversibleConverterMap);
    }

    @Override
    public <T> void registerReversibleMapper(Class<T> type, ReversibleMapper<S, T, ? extends E> mapper) {
        this.reversibleMapperMapper = this.register(type, mapper, this.reversibleMapperMapper);
    }

    @Override
    public <R> void registerReversibleTransformer(Class<R> type, ReversibleTransformer<S, R, ? extends E> reverser) {
        this.reversibleTransformerMap = this.register(type, reverser, this.reversibleTransformerMap);
    }

    @Override
    public <T> void registerTransformer(Class<T> type, Transformer<S, T, ? extends E> transformer) {
        this.transformerMap = this.register(type, transformer, this.transformerMap);
    }

    @Override
    public final void reverseTransform(Object source, Class<? extends Object> sourceType, S target) throws E {
        ReversibleMapperFactory.super.reverseTransform(source, sourceType, target);
    }

    @Override
    public final void reverseTransform(Object source, Class<? extends Object> sourceType, S target, Class<? extends S> targetType) throws E {
        ReversibleMapperFactory.super.reverseTransform(source, sourceType, target, targetType);
    }

    @Override
    public final void reverseTransform(Object source, Class<? extends Object> sourceType, S target, TypeDescriptor targetType) throws E {
        ReversibleMapperFactory.super.reverseTransform(source, sourceType, target, targetType);
    }

    @Override
    public final void reverseTransform(Object source, S target) throws E {
        ReversibleMapperFactory.super.reverseTransform(source, target);
    }

    @Override
    public final void reverseTransform(Object source, S target, Class<? extends S> targetType) throws E {
        ReversibleMapperFactory.super.reverseTransform(source, target, targetType);
    }

    @Override
    public final void reverseTransform(Object source, S target, TypeDescriptor targetType) throws E {
        ReversibleMapperFactory.super.reverseTransform(source, target, targetType);
    }

    @Override
    public final void reverseTransform(Object source, TypeDescriptor sourceType, S target) throws E {
        ReversibleMapperFactory.super.reverseTransform(source, sourceType, target);
    }

    @Override
    public final void reverseTransform(Object source, TypeDescriptor sourceType, S target, Class<? extends S> targetType) throws E {
        ReversibleMapperFactory.super.reverseTransform(source, sourceType, target, targetType);
    }

    @Override
    public final void transform(S source, Class<? extends S> sourceType, Object target) throws E {
        ReversibleMapperFactory.super.transform(source, sourceType, target);
    }

    @Override
    public final void transform(S source, Class<? extends S> sourceType, Object target, Class<? extends Object> targetType) throws E {
        ReversibleMapperFactory.super.transform(source, sourceType, target, targetType);
    }

    @Override
    public final void transform(S source, Class<? extends S> sourceType, Object target, TypeDescriptor targetType) throws E {
        ReversibleMapperFactory.super.transform(source, sourceType, target, targetType);
    }

    @Override
    public final void transform(S source, Object target) throws E {
        ReversibleMapperFactory.super.transform(source, target);
    }

    @Override
    public final void transform(S source, Object target, Class<? extends Object> targetType) throws E {
        ReversibleMapperFactory.super.transform(source, target, targetType);
    }

    @Override
    public final void transform(S source, Object target, TypeDescriptor targetType) throws E {
        ReversibleMapperFactory.super.transform(source, target, targetType);
    }

    @Override
    public final void transform(S source, TypeDescriptor sourceType, Object target) throws E {
        ReversibleMapperFactory.super.transform(source, sourceType, target);
    }

    @Override
    public final void transform(S source, TypeDescriptor sourceType, Object target, Class<? extends Object> targetType) throws E {
        ReversibleMapperFactory.super.transform(source, sourceType, target, targetType);
    }
}

