/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.core.reflect.ReflectionApi;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.CollectionFactory;

public interface ConverterConfiguration {
    default public Object newInstance(TypeDescriptor type) {
        if (type.isMap()) {
            return CollectionFactory.createMap(type.getType(), type.getMapKeyTypeDescriptor().getType(), 16);
        }
        if (type.isCollection()) {
            return CollectionFactory.createCollection(type.getType(), type.getElementTypeDescriptor().getType(), 16);
        }
        return ReflectionApi.newInstance(type.getType());
    }

    default public boolean canDirectlyConvert(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType != null && targetType != null && targetType.isAssignableTo(sourceType)) {
            return true;
        }
        return targetType.getType() == Object.class;
    }
}

