/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert;

import io.basc.framework.convert.Converter;
import io.basc.framework.convert.TransformerFactory;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.lang.Nullable;

public interface ConverterFactory<S, E extends Throwable>
extends TransformerFactory<S, E>,
Converter<S, Object, E> {
    default public boolean isConverterRegistred(Class<?> type) {
        return this.getConverter(type) != null;
    }

    @Nullable
    public <T> Converter<S, T, E> getConverter(Class<? extends T> var1);

    public <T> void registerConverter(Class<T> var1, Converter<S, ? extends T, ? extends E> var2);

    @Override
    default public Object convert(S source, TypeDescriptor sourceType, TypeDescriptor targetType) throws E {
        if (this.canDirectlyConvert(sourceType, targetType)) {
            return source;
        }
        Converter<S, ?, E> converter = this.getConverter(targetType.getType());
        if (converter == null) {
            Object target = this.newInstance(targetType);
            if (target == null) {
                return null;
            }
            this.transform(source, sourceType, target, targetType);
            return target;
        }
        return converter.convert(source, sourceType, targetType);
    }
}

