/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert;

import io.basc.framework.convert.Inverter;
import io.basc.framework.convert.ReverseTransformerFactory;
import io.basc.framework.convert.TypeDescriptor;

public interface InverterFactory<T, E extends Throwable>
extends ReverseTransformerFactory<T, E>,
Inverter<Object, T, E> {
    default public boolean isInverterRegistred(Class<?> type) {
        return this.getInverter(type) != null;
    }

    public <S> Inverter<S, T, E> getInverter(Class<? extends S> var1);

    public <S> void registerInverter(Class<S> var1, Inverter<S, ? extends T, ? extends E> var2);

    @Override
    default public T invert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) throws E {
        if (this.canDirectlyConvert(sourceType, targetType)) {
            return (T)source;
        }
        Inverter<?, T, E> inverter = this.getInverter(targetType.getType());
        if (inverter == null) {
            Object target = this.newInstance(targetType);
            if (target == null) {
                return null;
            }
            this.reverseTransform(source, sourceType, target, targetType);
            return (T)target;
        }
        return inverter.invert(source, sourceType, targetType);
    }
}

