/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert;

import io.basc.framework.convert.ConverterNotFoundException;
import io.basc.framework.convert.Transformer;
import io.basc.framework.convert.TypeDescriptor;

public interface TransformerFactory<S, E extends Throwable>
extends Transformer<S, Object, E> {
    default public boolean isTransformerRegistred(Class<?> type) {
        return this.getTransformer(type) != null;
    }

    public <T> Transformer<S, T, E> getTransformer(Class<? extends T> var1);

    public <T> void registerTransformer(Class<T> var1, Transformer<S, T, ? extends E> var2);

    @Override
    default public void transform(S source, TypeDescriptor sourceType, Object target, TypeDescriptor targetType) throws E, ConverterNotFoundException {
        Transformer<S, ?, E> transformer = this.getTransformer(targetType.getType());
        if (transformer == null) {
            throw new ConverterNotFoundException(sourceType, targetType);
        }
        transformer.transform(source, target, targetType);
    }
}

