/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert.lang;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.ConversionServiceAware;
import io.basc.framework.convert.ConverterNotFoundException;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.lang.ConversionComparator;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.lang.LinkedThreadLocal;
import io.basc.framework.value.Value;
import java.util.TreeSet;

public class ConfigurableConversionService
extends ConfigurableServices<ConversionService>
implements ConversionService,
Comparable<Object>,
Iterable<ConversionService> {
    private static final LinkedThreadLocal<ConversionService> NESTED = new LinkedThreadLocal(ConfigurableConversionService.class.getName());

    public ConfigurableConversionService() {
        super(ConversionService.class, () -> new TreeSet<Object>(ConversionComparator.INSTANCE));
    }

    @Override
    public void accept(ConversionService service) {
        if (service instanceof ConversionServiceAware) {
            ((ConversionServiceAware)((Object)service)).setConversionService(this);
        }
        super.accept(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        for (ConversionService service : this) {
            if (NESTED.isCurrent(service)) continue;
            NESTED.set(service);
            try {
                if (!service.canConvert(sourceType, targetType)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                NESTED.remove(service);
            }
        }
        return this.canDirectlyConvert(sourceType, targetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        TypeDescriptor sourceTypeToUse = sourceType;
        if (sourceType == null && source != null) {
            sourceTypeToUse = TypeDescriptor.forObject(source);
        }
        for (ConversionService service : this) {
            if (NESTED.isCurrent(service)) continue;
            NESTED.set(service);
            try {
                if (!service.canConvert(sourceType, targetType)) continue;
                Object t = service.convert(source, sourceTypeToUse, targetType);
                return t;
            }
            finally {
                NESTED.remove(service);
            }
        }
        if (this.canDirectlyConvert(sourceTypeToUse, targetType)) {
            return source;
        }
        if (sourceTypeToUse == null) {
            Object value = Value.EMPTY.getAsObject(targetType);
            return value;
        }
        throw new ConverterNotFoundException(sourceTypeToUse, targetType);
    }

    @Override
    public int compareTo(Object o) {
        for (ConversionService service : this) {
            if (ConversionComparator.INSTANCE.compare(service, o) != -1) continue;
            return -1;
        }
        return 1;
    }
}

