/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert.lang;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.lang.AbstractConversionService;
import io.basc.framework.json.JsonArray;
import io.basc.framework.json.JsonElement;
import io.basc.framework.json.JsonObject;

public class JsonConversionService
extends AbstractConversionService {
    private boolean isJsonType(Class<?> type, boolean isAssignableFrom) {
        if (isAssignableFrom) {
            return JsonElement.class.isAssignableFrom(type) || JsonArray.class.isAssignableFrom(type) || JsonObject.class.isAssignableFrom(type);
        }
        return JsonElement.class == type || JsonArray.class == type || JsonObject.class == type;
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType == null || targetType == null) {
            return false;
        }
        return this.isJsonType(sourceType.getType(), true) || this.isJsonType(targetType.getType(), false);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (this.isJsonType(sourceType.getType(), true)) {
            JsonElement jsonElement = (JsonElement)source;
            return jsonElement.getAsObject(targetType.getResolvableType().getType());
        }
        String text = (String)this.getConversionService().convert(source, sourceType, TypeDescriptor.valueOf(String.class));
        return this.getJsonSupport().parseObject(text, targetType.getResolvableType().getType());
    }
}

