/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert.lang;

import io.basc.framework.convert.ConversionException;
import io.basc.framework.convert.ConversionFactory;
import io.basc.framework.convert.ConversionFailedException;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.lang.ObjectToString;
import io.basc.framework.convert.lang.ReaderToString;
import io.basc.framework.convert.lang.ResourceToString;
import io.basc.framework.convert.lang.StringToEnum;
import io.basc.framework.io.Resource;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Optional;
import io.basc.framework.util.StringToBoolean;
import io.basc.framework.util.StringToByte;
import io.basc.framework.util.StringToCharacter;
import io.basc.framework.util.StringToCharset;
import io.basc.framework.util.StringToClass;
import io.basc.framework.util.StringToCurrency;
import io.basc.framework.util.StringToDouble;
import io.basc.framework.util.StringToFloat;
import io.basc.framework.util.StringToInteger;
import io.basc.framework.util.StringToLocale;
import io.basc.framework.util.StringToLong;
import io.basc.framework.util.StringToNumber;
import io.basc.framework.util.StringToShort;
import io.basc.framework.util.StringToTimeZone;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;

public class StringConverter
extends ConversionFactory<String, ConversionException> {
    public static final StringConverter DEFAULT = new StringConverter();
    private ObjectToString objectToString = ObjectToString.DEFAULT;
    private ReaderToString readerToString = ReaderToString.DEFAULT;
    private ResourceToString resourceToString = ResourceToString.DEFAULT;
    private StringToBoolean stringToBoolean = StringToBoolean.DEFAULT;
    private StringToByte stringToByte = StringToByte.DEFAULT;
    private StringToCharacter stringToCharacter = StringToCharacter.DEFAULT;
    private StringToCharset stringToCharset = StringToCharset.DEFAULT;
    private StringToClass stringToClass = StringToClass.DEFAULT;
    private StringToCurrency stringToCurrency = StringToCurrency.DEFAULT;
    private StringToDouble stringToDouble = StringToDouble.DEFAULT;
    private StringToEnum stringToEnum = StringToEnum.DEFAULT;
    private StringToFloat stringToFloat = StringToFloat.DEFAULT;
    private StringToInteger stringToInteger = StringToInteger.DEFAULT;
    private StringToLocale stringToLocale = StringToLocale.DEFAULT;
    private StringToLong stringToLong = StringToLong.DEFAULT;
    private StringToNumber stringToNumber = StringToNumber.DEFAULT;
    private StringToShort stringToShort = StringToShort.DEFAULT;
    private StringToTimeZone stringToTimeZone = StringToTimeZone.DEFAULT;

    public static <T> Optional<T> parse(String source, Class<T> type) {
        T value = DEFAULT.convert(source, type);
        return Optional.ofNullable(value);
    }

    public static boolean parseBoolean(String source) {
        return DEFAULT.convert(source, Boolean.TYPE);
    }

    public static boolean parseBoolean(String source, boolean defaultValue) {
        Boolean value = DEFAULT.convert(source, Boolean.class);
        return value == null ? defaultValue : value;
    }

    public static byte parseByte(String source) {
        return DEFAULT.convert(source, Byte.TYPE);
    }

    public static byte parseByte(String source, byte defaultValue) {
        Byte value = DEFAULT.convert(source, Byte.class);
        return value == null ? defaultValue : value;
    }

    public static char parseChar(String source) {
        return DEFAULT.convert(source, Character.TYPE).charValue();
    }

    public static double parseDouble(String source) {
        return DEFAULT.convert(source, Double.TYPE);
    }

    public static double parseDouble(String source, double defaultValue) {
        Double value = DEFAULT.convert(source, Double.class);
        return value == null ? defaultValue : value;
    }

    public static float parseFloat(String source) {
        return DEFAULT.convert(source, Float.TYPE).floatValue();
    }

    public static float parseFloat(String source, float defaultValue) {
        Float value = DEFAULT.convert(source, Float.class);
        return value == null ? defaultValue : value.floatValue();
    }

    public static int parseInt(String source) {
        return DEFAULT.convert(source, Integer.TYPE);
    }

    public static int parseInt(String source, int defaultValue) {
        Integer value = DEFAULT.convert(source, Integer.class);
        return value == null ? defaultValue : value;
    }

    public static long parseLong(String source) {
        return DEFAULT.convert(source, Long.TYPE);
    }

    public static long parseLong(String source, long defaultValue) {
        Long value = DEFAULT.convert(source, Long.class);
        return value == null ? defaultValue : value;
    }

    public static short parseShort(String source) {
        return DEFAULT.convert(source, Short.TYPE);
    }

    public static short parseShort(String source, short defaultValue) {
        Short value = DEFAULT.convert(source, Short.class);
        return value == null ? defaultValue : value;
    }

    public StringConverter() {
        this.registerConverter(Character.TYPE, (source, sourceType, targetType) -> Character.valueOf(this.stringToCharacter.applyAsChar((String)source)));
        this.registerConverter(Character.class, (source, sourceType, targetType) -> this.stringToCharacter.apply((String)source));
        this.registerConverter(Boolean.TYPE, (source, sourceType, targetType) -> this.stringToBoolean.applyAsBoolean((String)source));
        this.registerConverter(Boolean.class, (source, sourceType, targetType) -> this.stringToBoolean.apply((String)source));
        this.registerConverter(Byte.TYPE, (source, sourceType, targetType) -> this.stringToByte.applyAsByte((String)source));
        this.registerConverter(Byte.class, (source, sourceType, targetType) -> this.stringToByte.apply((String)source));
        this.registerConverter(Short.TYPE, (source, sourceType, targetType) -> this.stringToShort.applyAsShort((String)source));
        this.registerConverter(Short.class, (source, sourceType, targetType) -> this.stringToShort.apply((String)source));
        this.registerConverter(Integer.TYPE, (source, sourceType, targetType) -> this.stringToInteger.applyAsInt((String)source));
        this.registerConverter(Integer.class, (source, sourceType, targetType) -> this.stringToInteger.apply((String)source));
        this.registerConverter(Long.TYPE, (source, sourceType, targetType) -> this.stringToLong.applyAsLong((String)source));
        this.registerConverter(Long.class, (source, sourceType, targetType) -> this.stringToLong.apply((String)source));
        this.registerConverter(Float.TYPE, (source, sourceType, targetType) -> Float.valueOf(this.stringToFloat.applyAsFloat((String)source)));
        this.registerConverter(Float.class, (source, sourceType, targetType) -> this.stringToFloat.apply((String)source));
        this.registerConverter(Double.TYPE, (source, sourceType, targetType) -> this.stringToDouble.applyAsDouble((String)source));
        this.registerConverter(Double.class, (source, sourceType, targetType) -> this.stringToDouble.apply((String)source));
        this.registerConverter(Enum.class, this.stringToEnum);
        this.registerConverter(Number.class, (source, sourceType, targetType) -> this.stringToNumber.apply((String)source));
        this.registerConverter(Locale.class, (source, sourceType, targetType) -> this.stringToLocale.apply((String)source));
        this.registerConverter(Charset.class, (source, sourceType, targetType) -> this.stringToCharset.apply((String)source));
        this.registerConverter(Currency.class, (source, sourceType, targetType) -> this.stringToCurrency.apply((String)source));
        this.registerConverter(TimeZone.class, (source, sourceType, targetType) -> this.stringToTimeZone.apply((String)source));
        this.registerConverter(Class.class, (source, sourceType, targetType) -> this.stringToClass.apply((String)source));
        this.registerInverter(Reader.class, (R source, TypeDescriptor sourceType, TypeDescriptor targetType) -> {
            try {
                return this.readerToString.convert((Reader)source, sourceType, targetType);
            }
            catch (IOException e) {
                throw new ConversionFailedException(sourceType, targetType, source, e);
            }
        });
        this.registerInverter(Resource.class, (R source, TypeDescriptor sourceType, TypeDescriptor targetType) -> {
            try {
                return this.resourceToString.convert((Resource)source, sourceType, targetType);
            }
            catch (IOException e) {
                throw new ConversionFailedException(sourceType, targetType, source, e);
            }
        });
        this.registerInverter(Object.class, this.objectToString::convert);
    }

    public ObjectToString getObjectToString() {
        return this.objectToString;
    }

    public ReaderToString getReaderToString() {
        return this.readerToString;
    }

    public ResourceToString getResourceToString() {
        return this.resourceToString;
    }

    public StringToBoolean getStringToBoolean() {
        return this.stringToBoolean;
    }

    public StringToByte getStringToByte() {
        return this.stringToByte;
    }

    public StringToCharacter getStringToCharacter() {
        return this.stringToCharacter;
    }

    public StringToCharset getStringToCharset() {
        return this.stringToCharset;
    }

    public StringToClass getStringToClass() {
        return this.stringToClass;
    }

    public StringToCurrency getStringToCurrency() {
        return this.stringToCurrency;
    }

    public StringToDouble getStringToDouble() {
        return this.stringToDouble;
    }

    public StringToEnum getStringToEnum() {
        return this.stringToEnum;
    }

    public StringToFloat getStringToFloat() {
        return this.stringToFloat;
    }

    public StringToInteger getStringToInteger() {
        return this.stringToInteger;
    }

    public StringToLocale getStringToLocale() {
        return this.stringToLocale;
    }

    public StringToLong getStringToLong() {
        return this.stringToLong;
    }

    public StringToNumber getStringToNumber() {
        return this.stringToNumber;
    }

    public StringToShort getStringToShort() {
        return this.stringToShort;
    }

    public StringToTimeZone getStringToTimeZone() {
        return this.stringToTimeZone;
    }

    public void setObjectToString(ObjectToString objectToString) {
        Assert.requiredArgument(objectToString != null, "objectToString");
        this.objectToString = objectToString;
    }

    public void setReaderToString(ReaderToString readerToString) {
        Assert.requiredArgument(readerToString != null, "readerToString");
        this.readerToString = readerToString;
    }

    public void setResourceToString(ResourceToString resourceToString) {
        Assert.requiredArgument(resourceToString != null, "resourceToString");
        this.resourceToString = resourceToString;
    }

    public void setStringToBoolean(StringToBoolean stringToBoolean) {
        Assert.requiredArgument(stringToBoolean != null, "stringToBoolean");
        this.stringToBoolean = stringToBoolean;
    }

    public void setStringToByte(StringToByte stringToByte) {
        Assert.requiredArgument(stringToByte != null, "stringToByte");
        this.stringToByte = stringToByte;
    }

    public void setStringToCharacter(StringToCharacter stringToCharacter) {
        Assert.requiredArgument(stringToCharacter != null, "stringToCharacter");
        this.stringToCharacter = stringToCharacter;
    }

    public void setStringToCharset(StringToCharset stringToCharset) {
        Assert.requiredArgument(stringToCharset != null, "stringToCharset");
        this.stringToCharset = stringToCharset;
    }

    public void setStringToClass(StringToClass stringToClass) {
        Assert.requiredArgument(stringToClass != null, "stringToClass");
        this.stringToClass = stringToClass;
    }

    public void setStringToCurrency(StringToCurrency stringToCurrency) {
        Assert.requiredArgument(stringToCurrency != null, "stringToCurrency");
        this.stringToCurrency = stringToCurrency;
    }

    public void setStringToDouble(StringToDouble stringToDouble) {
        Assert.requiredArgument(stringToDouble != null, "stringToDouble");
        this.stringToDouble = stringToDouble;
    }

    public void setStringToEnum(StringToEnum stringToEnum) {
        Assert.requiredArgument(stringToEnum != null, "stringToEnum");
        this.stringToEnum = stringToEnum;
    }

    public void setStringToFloat(StringToFloat stringToFloat) {
        Assert.requiredArgument(stringToFloat != null, "stringToFloat");
        this.stringToFloat = stringToFloat;
    }

    public void setStringToInteger(StringToInteger stringToInteger) {
        Assert.requiredArgument(stringToInteger != null, "stringToInteger");
        this.stringToInteger = stringToInteger;
    }

    public void setStringToLocale(StringToLocale stringToLocale) {
        Assert.requiredArgument(stringToLocale != null, "stringToLocale");
        this.stringToLocale = stringToLocale;
    }

    public void setStringToLong(StringToLong stringToLong) {
        Assert.requiredArgument(stringToLong != null, "stringToLong");
        this.stringToLong = stringToLong;
    }

    public void setStringToNumber(StringToNumber stringToNumber) {
        Assert.requiredArgument(stringToNumber != null, "stringToNumber");
        this.stringToNumber = stringToNumber;
    }

    public void setStringToShort(StringToShort stringToShort) {
        Assert.requiredArgument(stringToShort != null, "stringToShort");
        this.stringToShort = stringToShort;
    }

    public void setStringToTimeZone(StringToTimeZone stringToTimeZone) {
        Assert.requiredArgument(stringToTimeZone != null, "stringToTimeZone");
        this.stringToTimeZone = stringToTimeZone;
    }
}

