/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert.resolve;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.ConversionServiceAware;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.resolve.ResourceResolver;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.io.Resource;
import io.basc.framework.io.resolver.PropertiesResolvers;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.StaticSupplier;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.function.Supplier;

public class ResourceResolvers
extends ConfigurableServices<ResourceResolver>
implements ResourceResolver {
    private static final TypeDescriptor PROPERTIES_TYPE = TypeDescriptor.valueOf(Properties.class);
    private final PropertiesResolvers propertiesResolvers;
    private final Supplier<Charset> charset;
    private final ConversionService conversionService;

    public ResourceResolvers(ConversionService conversionService) {
        this(conversionService, (Charset)null);
    }

    public ResourceResolvers(ConversionService conversionService, @Nullable Charset charset) {
        this(conversionService, (Supplier<Charset>)(charset == null ? null : new StaticSupplier<Charset>(charset)));
    }

    public ResourceResolvers(ConversionService conversionService, @Nullable Supplier<Charset> charset) {
        this(new PropertiesResolvers(), conversionService, charset);
    }

    public ResourceResolvers(PropertiesResolvers propertiesResolvers, ConversionService conversionService, @Nullable Supplier<Charset> charset) {
        super(ResourceResolver.class);
        this.propertiesResolvers = propertiesResolvers;
        this.conversionService = conversionService;
        this.charset = charset;
    }

    @Override
    public void accept(ResourceResolver service) {
        if (service instanceof ConversionServiceAware) {
            ((ConversionServiceAware)((Object)service)).setConversionService(this.getConversionService());
        }
        super.accept(service);
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        this.propertiesResolvers.configure(serviceLoaderFactory);
        super.configure(serviceLoaderFactory);
    }

    public PropertiesResolvers getPropertiesResolvers() {
        return this.propertiesResolvers;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public boolean canResolveResource(Resource resource, TypeDescriptor targetType) {
        for (ResourceResolver resolver : this) {
            if (!resolver.canResolveResource(resource, targetType)) continue;
            return true;
        }
        return this.getPropertiesResolvers().canResolveProperties(resource) && this.getConversionService().canConvert(PROPERTIES_TYPE, targetType);
    }

    @Override
    public Object resolveResource(Resource resource, TypeDescriptor targetType) {
        for (ResourceResolver resolver : this) {
            if (!resolver.canResolveResource(resource, targetType)) continue;
            return resolver.resolveResource(resource, targetType);
        }
        if (this.getPropertiesResolvers().canResolveProperties(resource)) {
            Properties properties = new Properties();
            this.getPropertiesResolvers().resolveProperties(properties, resource, this.charset == null ? null : this.charset.get());
            return this.getConversionService().convert(properties, PROPERTIES_TYPE, targetType);
        }
        return this.conversionService.convert(resource, TypeDescriptor.forObject(resource), targetType);
    }
}

