/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.convert.support;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.lang.AbstractConversionService;
import io.basc.framework.convert.lang.ConditionalConversionService;
import io.basc.framework.convert.lang.ConvertiblePair;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.CollectionFactory;
import io.basc.framework.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

class MapToMapConversionService
extends AbstractConversionService
implements ConditionalConversionService {
    public MapToMapConversionService(ConversionService conversionService) {
        this.setConversionService(conversionService);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        boolean copyRequired;
        if (source == null) {
            return null;
        }
        Map sourceMap = (Map)source;
        boolean bl = copyRequired = !targetType.getType().isInstance(source);
        if (!copyRequired && sourceMap.isEmpty()) {
            return sourceMap;
        }
        TypeDescriptor keyDesc = targetType.getMapKeyTypeDescriptor();
        TypeDescriptor valueDesc = targetType.getMapValueTypeDescriptor();
        ArrayList<Pair<Object, Object>> targetEntries = new ArrayList<Pair<Object, Object>>(sourceMap.size());
        for (Map.Entry entry : sourceMap.entrySet()) {
            Object k = entry.getKey();
            Object sourceValue = entry.getValue();
            Object targetKey = this.convertKey(k, sourceType, keyDesc);
            Object targetValue = this.convertValue(sourceValue, sourceType, valueDesc);
            targetEntries.add(new Pair<Object, Object>(targetKey, targetValue));
            if (k == targetKey && sourceValue == targetValue) continue;
            copyRequired = true;
        }
        if (!copyRequired) {
            return sourceMap;
        }
        Map targetMap = CollectionFactory.createMap(targetType.getType(), keyDesc != null ? keyDesc.getType() : null, sourceMap.size());
        for (Pair pair : targetEntries) {
            targetMap.put(pair.getKey(), pair.getValue());
        }
        return targetMap;
    }

    private Object convertKey(Object sourceKey, TypeDescriptor sourceType, @Nullable TypeDescriptor targetType) {
        if (targetType == null) {
            return sourceKey;
        }
        return this.getConversionService().convert(sourceKey, sourceType.getMapKeyTypeDescriptor(sourceKey), targetType);
    }

    private Object convertValue(Object sourceValue, TypeDescriptor sourceType, @Nullable TypeDescriptor targetType) {
        if (targetType == null) {
            return sourceValue;
        }
        return this.getConversionService().convert(sourceValue, sourceType.getMapValueTypeDescriptor(sourceValue), targetType);
    }

    @Override
    public Set<ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new ConvertiblePair(Map.class, Map.class));
    }
}

