/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.XUtils;
import io.basc.framework.util.page.Pageables;
import io.basc.framework.util.page.PageablesIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Members<T>
implements Cloneable,
Pageables<Class<?>, T> {
    public static final WithMethod DIRECT = new Direct();
    public static final WithMethod REFUSE = new Refuse();
    public static final WithMethod COVER = new Cover();
    @Nullable
    private List<T> members;
    private Function<Class<?>, ? extends Stream<T>> processor;
    private Class<?> sourceClass;
    @Nullable
    private Supplier<? extends Stream<T>> streamSupplier;
    @Nullable
    private Members<T> with;
    private WithMethod withMethod = REFUSE;

    public Members(Class<?> sourceClass, Function<Class<?>, ? extends Stream<T>> processor) {
        Assert.requiredArgument(sourceClass != null, "sourceClass");
        Assert.requiredArgument(processor != null, "processor");
        this.sourceClass = sourceClass;
        this.processor = processor;
    }

    public Members(Members<T> members) {
        Assert.requiredArgument(members != null, "members");
        this.sourceClass = members.sourceClass;
        this.processor = members.processor;
        this.streamSupplier = members.streamSupplier;
        this.with = members.with;
        this.members = members.members == null ? null : new ArrayList<T>(members.members);
        this.withMethod = members.withMethod;
    }

    public Members<T> withMethod(WithMethod method) {
        Assert.requiredArgument(method != null, "method");
        Object members = this.clone();
        ((Members)members).withMethod = method;
        return members;
    }

    public WithMethod getWithMethod() {
        return this.withMethod;
    }

    public Members<T> all() {
        Members<T> members = new Members<T>(this.sourceClass, this.processor);
        members.withMethod = this.withMethod;
        members.streamSupplier = () -> Pageables.super.all().stream();
        return members;
    }

    public Members<T> clone() {
        Members<T> clone = new Members<T>(this.sourceClass, this.processor);
        if (this.with != null) {
            clone.with = this.with.clone();
        }
        if (this.streamSupplier != null) {
            clone.streamSupplier = this.streamSupplier;
        }
        if (this.members != null) {
            clone.members = this.members;
        }
        clone.withMethod = this.withMethod;
        return clone;
    }

    public final boolean contains(Class<?> sourceClass) {
        if (sourceClass == null) {
            return false;
        }
        Members<T> members = this;
        while (members != null) {
            if (ClassUtils.sameName(members.sourceClass, sourceClass)) {
                return true;
            }
            members = members.with;
        }
        return false;
    }

    public Members<T> distinct() {
        Members<T> members = new Members<T>(this.sourceClass, this.processor);
        members.streamSupplier = () -> this.stream().distinct();
        if (members.with != null) {
            members.with = this.with.distinct();
        }
        return members;
    }

    public Members<T> exclude(Predicate<? super T> predicate) {
        if (predicate == null) {
            return this;
        }
        return this.filter((Predicate)predicate.negate());
    }

    @Override
    public Members<T> filter(Predicate<? super T> predicate) {
        if (predicate == null) {
            return this;
        }
        return this.mapProcessor(s -> s == null ? s : s.filter(predicate));
    }

    @Override
    public final Class<?> getCursorId() {
        return this.sourceClass;
    }

    @Override
    public Cursor<T> iterator() {
        return Cursor.of(this.stream());
    }

    @Override
    public final Class<?> getNextCursorId() {
        return this.with == null ? null : this.with.sourceClass;
    }

    public Function<Class<?>, ? extends Stream<T>> getProcessor() {
        return this.processor;
    }

    public final Class<?> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public final boolean hasNext() {
        return this.with != null;
    }

    public Members<T> jumpTo(Class<?> cursorId) {
        return new Members<T>(this.sourceClass, this.processor);
    }

    @Override
    public <TT> Members<TT> map(Function<? super T, ? extends TT> map) {
        return this.mapProcessor(s -> s == null ? null : s.map(map));
    }

    public <S> Members<S> mapProcessor(Function<Stream<T>, ? extends Stream<S>> processor) {
        Assert.requiredArgument(processor != null, "processor");
        return this.mapProcessor(processor, e -> (Stream)processor.apply(this.processor.apply((Class<?>)e)), this.processor);
    }

    private <S> Members<S> mapProcessor(Function<Stream<T>, ? extends Stream<S>> processor, Function<Class<?>, ? extends Stream<S>> rootMapProcessor, Function<Class<?>, ? extends Stream<T>> rootProcessor) {
        Members<T> members = new Members<T>(this.sourceClass, this.processor == rootProcessor ? rootMapProcessor : e -> (Stream)processor.apply(this.processor.apply((Class<?>)e)));
        if (this.with != null) {
            members.with = super.mapProcessor(processor, rootMapProcessor, rootProcessor);
        }
        if (this.streamSupplier != null) {
            members.streamSupplier = () -> (Stream)processor.apply(this.streamSupplier.get());
        }
        if (this.members != null) {
            members.members = processor.apply(this.members.stream()).collect(Collectors.toList());
        }
        return members;
    }

    public Members<T> next() {
        return this.with;
    }

    @Override
    public Stream<? extends Members<T>> pages() {
        return XUtils.stream(new PageablesIterator<Members>(this, e -> e.next()));
    }

    public void setMembers(List<T> members) {
        this.members = members;
    }

    @Override
    public Members<T> shared() {
        Object members = this.clone();
        if (((Members)members).members == null) {
            ((Members)members).members = members.getList();
        }
        if (((Members)members).with != null) {
            ((Members)members).with = ((Members)members).with.shared();
        }
        return members;
    }

    @Override
    public Stream<T> stream() {
        if (this.members != null) {
            return this.members.stream();
        }
        Stream<T> stream = this.streamSupplier == null ? this.processor.apply(this.sourceClass) : this.streamSupplier.get();
        return stream == null ? XUtils.emptyStream() : stream;
    }

    public Members<T> with(Members<T> with) {
        if (with == null) {
            return this;
        }
        this.withMethod.with(with, this);
        return this;
    }

    public Members<T> withAll() {
        return this.withAll(null, this.processor);
    }

    public Members<T> withAll(@Nullable Predicate<Class<?>> predicate) {
        return this.withInterfaces(predicate).withSuperclass(predicate);
    }

    public Members<T> withAll(@Nullable Predicate<Class<?>> predicate, Function<Class<?>, ? extends Stream<T>> processor) {
        return this.withInterfaces(predicate, processor).withSuperclass(predicate, processor);
    }

    public Members<T> withClass(Class<?> sourceClass) {
        return this.with(new Members<T>(sourceClass, this.processor));
    }

    public Members<T> withClass(Class<?> sourceClass, Predicate<? super T> predicate) {
        Members<T> members = new Members<T>(sourceClass, this.processor.andThen(e -> e == null ? e : e.filter(predicate)));
        return this.with(members);
    }

    public Members<T> withInterfaces() {
        return this.withInterfaces(null, this.processor);
    }

    public Members<T> withInterfaces(@Nullable Predicate<Class<?>> predicate) {
        return this.withInterfaces(predicate, this.processor);
    }

    public Members<T> withInterfaces(@Nullable Predicate<Class<?>> predicate, Function<Class<?>, ? extends Stream<T>> processor) {
        Assert.requiredArgument(processor != null, "processor");
        Class<?>[] interfaces = this.sourceClass.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return this;
        }
        Members<T> members = this;
        for (Class<?> interfaceClass : interfaces) {
            if (predicate != null && !predicate.test(interfaceClass)) break;
            members = members.with(new Members<T>(interfaceClass, processor));
        }
        return members;
    }

    public Members<T> concat(Supplier<? extends Stream<? extends T>> streamSupplier) {
        Assert.requiredArgument(streamSupplier != null, "streamSupplier");
        Object clone = this.clone();
        if (((Members)clone).members != null) {
            Stream<? extends T> stream = streamSupplier.get();
            if (stream != null) {
                ((Members)clone).members = Stream.concat(this.members.stream(), stream).collect(Collectors.toList());
            }
            return clone;
        }
        ((Members)clone).streamSupplier = () -> {
            Stream stream = (Stream)streamSupplier.get();
            return stream == null ? this.stream() : Stream.concat(this.stream(), stream);
        };
        return clone;
    }

    public Members<T> withSuperclass() {
        return this.withSuperclass(false);
    }

    public Members<T> withSuperclass(boolean interfaces) {
        return this.withSuperclass(interfaces, null, this.processor);
    }

    public Members<T> withSuperclass(boolean interfaces, @Nullable Predicate<Class<?>> predicate) {
        return this.withSuperclass(interfaces, predicate, this.processor);
    }

    public Members<T> withSuperclass(boolean interfaces, @Nullable Predicate<Class<?>> predicate, Function<Class<?>, ? extends Stream<T>> processor) {
        Assert.requiredArgument(processor != null, "processor");
        Members<T> members = this;
        for (Class<?> superclass = this.sourceClass.getSuperclass(); superclass != null && (predicate == null || predicate.test(superclass)); superclass = superclass.getSuperclass()) {
            members = members.with(new Members<T>(superclass, processor));
            if (!interfaces) continue;
            members = members.withInterfaces(predicate, processor);
        }
        return members;
    }

    public Members<T> withSuperclass(@Nullable Predicate<Class<?>> predicate) {
        return this.withSuperclass(false, predicate);
    }

    public Members<T> withSuperclass(@Nullable Predicate<Class<?>> predicate, Function<Class<?>, ? extends Stream<T>> processor) {
        return this.withSuperclass(false, predicate, processor);
    }

    private static class Cover
    implements WithMethod {
        private Cover() {
        }

        @Override
        public <T> void with(Members<T> source, Members<T> target) {
            if (source == null) {
                return;
            }
            Members with = source;
            while (with != null) {
                Object item = with.clone();
                ((Members)item).with = null;
                boolean use = false;
                Members targetWith = target;
                while (targetWith != null) {
                    if (ClassUtils.sameName(((Members)item).sourceClass, targetWith.sourceClass)) {
                        use = true;
                        if (targetWith == target) {
                            targetWith.members = item.getList();
                            break;
                        }
                        targetWith.sourceClass = ((Members)item).sourceClass;
                        targetWith.members = ((Members)item).members;
                        targetWith.processor = ((Members)item).processor;
                        targetWith.streamSupplier = ((Members)item).streamSupplier;
                        break;
                    }
                    targetWith = targetWith.with;
                }
                if (!use) {
                    targetWith.with = (Members)item;
                }
                with = with.with;
            }
        }
    }

    private static class Refuse
    extends Direct {
        private Refuse() {
        }

        @Override
        public <T> void with(Members<T> source, Members<T> target) {
            if (source == null) {
                return;
            }
            if (target.contains(((Members)source).sourceClass)) {
                this.with(((Members)source).with, target);
                return;
            }
            super.with(source, target);
        }
    }

    private static class Direct
    implements WithMethod {
        private Direct() {
        }

        @Override
        public <T> void with(Members<T> source, Members<T> target) {
            if (source == null) {
                return;
            }
            Members with = target;
            while (with.with != null) {
                with = with.with;
            }
            with.with = (Members)source;
        }
    }

    public static interface WithMethod {
        public <T> void with(Members<T> var1, Members<T> var2);
    }
}

