/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.annotation;

import io.basc.framework.core.annotation.Annotations;
import io.basc.framework.core.annotation.EmptyAnnotatedElement;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;

public class AnnotationArrayAnnotatedElement
implements AnnotatedElement,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Annotation[] annotations;
    protected final Annotation[] declaredAnnotations;

    public AnnotationArrayAnnotatedElement(AnnotatedElement annotatedElement) {
        if (annotatedElement == null || annotatedElement instanceof EmptyAnnotatedElement) {
            this.annotations = Annotations.EMPTY;
            this.declaredAnnotations = Annotations.EMPTY;
        } else if (annotatedElement instanceof AnnotationArrayAnnotatedElement) {
            this.annotations = ((AnnotationArrayAnnotatedElement)annotatedElement).annotations;
            this.declaredAnnotations = ((AnnotationArrayAnnotatedElement)annotatedElement).declaredAnnotations;
        } else {
            this.annotations = annotatedElement.getAnnotations();
            this.declaredAnnotations = annotatedElement.getDeclaredAnnotations();
        }
    }

    public AnnotationArrayAnnotatedElement(Annotation[] annotations) {
        this(annotations, annotations);
    }

    public AnnotationArrayAnnotatedElement(Annotation[] annotations, Annotation[] declaredAnnotations) {
        this.annotations = annotations == null ? Annotations.EMPTY : annotations;
        this.declaredAnnotations = declaredAnnotations == null ? Annotations.EMPTY : declaredAnnotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation ann : this.annotations) {
            if (ann.annotationType() != annotationClass) continue;
            return (T)ann;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return (Annotation[])this.annotations.clone();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return (Annotation[])this.declaredAnnotations.clone();
    }

    public String toString() {
        return "AnnotationArrayAnnotatedElement(annotations=" + Arrays.toString(this.annotations) + ", declaredAnnotations=" + Arrays.toString(this.declaredAnnotations) + ")";
    }
}

