/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.annotation;

import io.basc.framework.core.annotation.AnnotatedElementUtils;
import io.basc.framework.core.annotation.CharsetName;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.function.Supplier;

public final class Annotations {
    public static final Annotation[] EMPTY = new Annotation[0];

    @Nullable
    public static <T extends Annotation> T getAnnotation(Class<T> type, AnnotatedElement ... annotatedElements) {
        T old = null;
        for (AnnotatedElement annotatedElement : annotatedElements) {
            T a = AnnotatedElementUtils.getMergedAnnotation(annotatedElement, type);
            if (a == null) continue;
            old = a;
        }
        return old;
    }

    public static String getCharsetName(AnnotatedElement annotatedElement, Supplier<String> defaultSupplier) {
        CharsetName charsetName = AnnotatedElementUtils.getMergedAnnotation(annotatedElement, CharsetName.class);
        if (charsetName == null || !StringUtils.hasText(charsetName.value())) {
            return defaultSupplier == null ? null : defaultSupplier.get();
        }
        return charsetName.value();
    }

    public static Boolean isNullable(AnnotatedElement annotatedElement) {
        Nullable nullable = AnnotatedElementUtils.getMergedAnnotation(annotatedElement, Nullable.class);
        if (nullable == null) {
            return false;
        }
        return nullable.value();
    }

    public static Boolean isNullable(AnnotatedElement annotatedElement, Supplier<Boolean> defaultSupplier) {
        Nullable nullable = AnnotatedElementUtils.getMergedAnnotation(annotatedElement, Nullable.class);
        if (nullable == null) {
            return defaultSupplier == null ? null : defaultSupplier.get();
        }
        return nullable.value();
    }
}

