/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.reflect;

import io.basc.framework.core.reflect.MethodHolder;
import io.basc.framework.core.reflect.MethodInvoker;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.core.reflect.SerializableMethod;
import io.basc.framework.factory.InstanceFactory;
import io.basc.framework.factory.NameInstanceSupplier;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class DefaultMethodInvoker
implements MethodInvoker,
Serializable,
Cloneable,
Supplier<Object> {
    private static final long serialVersionUID = 1L;
    private final MethodHolder methodHolder;
    private Supplier<?> instanceSupplier;
    private volatile Object instance;
    private final Class<?> sourceClass;
    private final AtomicBoolean get = new AtomicBoolean();

    public DefaultMethodInvoker(Object instance, Class<?> sourceClass, Method method) {
        this(instance, sourceClass, method, false);
    }

    public DefaultMethodInvoker(InstanceFactory instanceFactory, String instanceName, Class<?> sourceClass, Method method) {
        this(sourceClass, Modifier.isStatic(method.getModifiers()) ? null : new NameInstanceSupplier(instanceFactory, instanceName), () -> method);
    }

    public DefaultMethodInvoker(Object instance, Class<?> sourceClass, Method method, boolean serialzerable) {
        this(sourceClass, instance, serialzerable ? new SerializableMethod(method) : () -> method);
    }

    public DefaultMethodInvoker(Supplier<?> instanceSupplier, Class<?> sourceClass, Method method, boolean serialzerable) {
        this(sourceClass, instanceSupplier, serialzerable ? new SerializableMethod(method) : () -> method);
    }

    public DefaultMethodInvoker(Class<?> sourceClass, Object instance, MethodHolder methodHolder) {
        this.sourceClass = sourceClass;
        this.methodHolder = methodHolder;
        this.instance = instance;
    }

    public DefaultMethodInvoker(Class<?> sourceClass, Supplier<?> instanceSupplier, MethodHolder methodHolder) {
        this.sourceClass = sourceClass;
        this.methodHolder = methodHolder;
        this.instanceSupplier = instanceSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() {
        if (this.instance == null && this.instanceSupplier != null && !this.get.get()) {
            DefaultMethodInvoker defaultMethodInvoker = this;
            synchronized (defaultMethodInvoker) {
                if (this.instance == null && this.get.compareAndSet(false, true)) {
                    this.instance = this.instanceSupplier.get();
                }
            }
        }
        return this.instance;
    }

    @Override
    public Object getInstance() {
        return this.get();
    }

    @Override
    public Method getMethod() {
        return this.methodHolder.getMethod();
    }

    @Override
    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public Object invoke(Object ... args) throws Throwable {
        Method method = this.getMethod();
        ReflectionUtils.makeAccessible(method);
        return ReflectionUtils.invoke(method, Modifier.isStatic(method.getModifiers()) ? null : this.getInstance(), args);
    }

    public String toString() {
        return this.getMethod().toString();
    }

    public DefaultMethodInvoker clone() {
        return new DefaultMethodInvoker(this.sourceClass, this, this.methodHolder);
    }
}

