/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.reflect;

import io.basc.framework.util.Assert;
import java.lang.reflect.Executable;

public class ExecutableMatchingResults<E extends Executable>
implements Comparable<ExecutableMatchingResults<E>> {
    private final E executable;
    private final Object[] params;
    private final int matchingResultes;

    public ExecutableMatchingResults(E executable, Object[] params, int matchingResultes) {
        Assert.requiredArgument(executable != null, "executable");
        Assert.requiredArgument(params != null, "params");
        this.executable = executable;
        this.params = params;
        this.matchingResultes = matchingResultes;
    }

    public E getExecutable() {
        return this.executable;
    }

    public Object[] getUnsafeParams() {
        return this.params;
    }

    public Object[] getParams() {
        return (Object[])this.params.clone();
    }

    public int getMatchingResultes() {
        return this.matchingResultes;
    }

    public boolean isJust() {
        return this.params.length == this.matchingResultes;
    }

    @Override
    public int compareTo(ExecutableMatchingResults<E> o) {
        return this.isJust() && o.isJust() ? Integer.compare(o.getMatchingResultes(), this.getMatchingResultes()) : (this.isJust() ? 1 : (o.isJust() ? -1 : 0));
    }
}

