/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.env;

import io.basc.framework.env.ProfilesResolver;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.StringUtils;
import io.basc.framework.value.Value;
import io.basc.framework.value.ValueFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class DefaultProfilesResolver
implements ProfilesResolver {
    private static final String[] PROFILES = new String[]{"io.basc.framework.env.profiles", "io_basc_framework_env_profiles"};
    public static final ProfilesResolver INSTANCE = new DefaultProfilesResolver();
    private String connector = "-";
    private boolean ignoreCase = true;

    public String getConnector() {
        return this.connector == null ? "" : this.connector;
    }

    public void setConnector(String connector) {
        this.connector = connector;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public Collection<String> resolve(ValueFactory<String> factory, String name) {
        Object[] profiles = this.getProfiles(factory);
        if (ArrayUtils.isEmpty(profiles)) {
            return Arrays.asList(name);
        }
        ArrayList<String> list = new ArrayList<String>(profiles.length + 1);
        String connector = this.getConnector();
        for (int i = profiles.length - 1; i >= 0; --i) {
            list.add(this.resolve(name, connector, (String)profiles[i]));
        }
        list.add(name);
        return list;
    }

    protected String resolve(String name, String connector, String profile) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return name + connector + profile;
        }
        return name.substring(0, index) + connector + profile + name.substring(index);
    }

    @Override
    public String[] getProfiles(ValueFactory<String> factory) {
        Value value = null;
        for (String key : PROFILES) {
            value = factory.get(key);
            if (this.isIgnoreCase() && (value == null || value.isEmpty())) {
                value = factory.get(key.toUpperCase());
            }
            if (value == null || value.isEmpty()) continue;
            return value.getAsObject(String[].class);
        }
        return StringUtils.EMPTY_ARRAY;
    }
}

