/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.env;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.convert.resolve.ResourceResolver;
import io.basc.framework.env.EnvironmentProperties;
import io.basc.framework.env.EnvironmentResourceLoader;
import io.basc.framework.event.Observable;
import io.basc.framework.event.support.ObservableProperties;
import io.basc.framework.factory.BeanFactory;
import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourceUtils;
import io.basc.framework.io.resolver.PropertiesResolver;
import io.basc.framework.lang.Constants;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.ServiceLoader;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.placeholder.PlaceholderFormat;
import io.basc.framework.util.placeholder.PlaceholderReplacer;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.function.Function;

public interface Environment
extends BeanFactory,
PlaceholderFormat {
    public static final String CHARSET_PROPERTY = "io.basc.framework.charset.name";
    public static final String WORK_PATH_PROPERTY = "io.basc.framework.work.path";

    default public Charset getCharset() {
        return this.getProperties().get(CHARSET_PROPERTY).as(Charset.class).orElse(Constants.UTF_8);
    }

    default public String getCharsetName() {
        return this.getProperties().get(CHARSET_PROPERTY).as(String.class).orElse("UTF-8");
    }

    public ServiceLoader<Resource> getResources();

    public ConversionService getConversionService();

    default public Observable<Charset> getObservableCharset() {
        return this.getProperties().getObservable(CHARSET_PROPERTY).map(e -> e.or(Constants.UTF_8).getAsObject(Charset.class));
    }

    default public Observable<String> getObservableCharsetName() {
        return this.getProperties().getObservable(CHARSET_PROPERTY).map(e -> e.or("UTF-8").getAsString());
    }

    default public Observable<String> getObservableWorkPath() {
        return this.getProperties().getObservable(WORK_PATH_PROPERTY).map(e -> e.getAsString());
    }

    public PlaceholderReplacer getPlaceholderReplacer();

    default public Observable<Properties> getProperties(PropertiesResolver propertiesResolver, String location) {
        return this.getProperties(propertiesResolver, location, (String)null);
    }

    default public Observable<Properties> getProperties(PropertiesResolver propertiesResolver, String location, @Nullable Charset charset) {
        Object[] resources = this.getResourceLoader().getResources(location);
        if (ArrayUtils.isEmpty(resources)) {
            return Observable.empty();
        }
        return this.toObservableProperties(propertiesResolver, charset, (Resource[])ArrayUtils.reversal(resources));
    }

    default public Observable<Properties> getProperties(PropertiesResolver propertiesResolver, String location, @Nullable String charsetName) {
        return this.getProperties(propertiesResolver, location, StringUtils.isEmpty(charsetName) ? null : Charset.forName(charsetName));
    }

    default public Observable<Properties> getProperties(String location) {
        return this.getProperties(this.getPropertiesResolver(), location);
    }

    default public Observable<Properties> getProperties(String location, @Nullable Charset charset) {
        return this.getProperties(this.getPropertiesResolver(), location, charset);
    }

    default public Observable<Properties> getProperties(String location, @Nullable String charsetName) {
        return this.getProperties(this.getPropertiesResolver(), location, charsetName);
    }

    public PropertiesResolver getPropertiesResolver();

    public EnvironmentProperties getProperties();

    public EnvironmentResourceLoader getResourceLoader();

    public ResourceResolver getResourceResolver();

    default public String getWorkPath() {
        return this.getProperties().getAsString(WORK_PATH_PROPERTY);
    }

    @Override
    default public String replacePlaceholders(String text) {
        return this.getPlaceholderReplacer().replacePlaceholders(text, name -> this.getProperties().getAsString(name));
    }

    @Override
    default public String replaceRequiredPlaceholders(String text) throws IllegalArgumentException {
        return this.getPlaceholderReplacer().replaceRequiredPlaceholders(text, name -> this.getProperties().getAsString(name));
    }

    default public Object resolveResource(String location, TypeDescriptor targetType) {
        Resource resource = this.getResourceLoader().getResource(location);
        if (resource == null || !resource.exists()) {
            return null;
        }
        return this.getResourceResolver().resolveResource(resource, targetType);
    }

    default public Observable<Properties> toObservableProperties(PropertiesResolver propertiesResolver, @Nullable Charset charset, Resource ... resources) {
        ObservableProperties properties = new ObservableProperties();
        Function<Resource, Properties> converter = ResourceUtils.toPropertiesConverter(propertiesResolver, charset);
        for (Resource resource : resources) {
            properties.register(resource.map(converter));
        }
        return properties;
    }

    default public Observable<Properties> toObservableProperties(Resource ... resources) {
        return this.toObservableProperties(this.getPropertiesResolver(), this.getCharset(), resources);
    }
}

