/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.env;

import io.basc.framework.core.Ordered;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Pair;
import io.basc.framework.util.StringUtils;
import io.basc.framework.value.PropertyFactory;
import io.basc.framework.value.Value;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.OptionalInt;

public class MainArgs
implements PropertyFactory,
Ordered {
    private final String[] args;

    public MainArgs(String[] args) {
        this.args = args == null ? new String[]{} : (String[])args.clone();
    }

    public int indexOf(String value) {
        for (int i = 0; i < this.args.length; ++i) {
            if (!value.equals(this.args[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(String value) {
        return this.indexOf(value) != -1;
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Value get(int index) {
        return Value.of(this.args[index]);
    }

    public int length() {
        return this.args.length;
    }

    public String[] getArgs() {
        return (String[])this.args.clone();
    }

    public Value getNextValue(String instructionName) {
        int index = this.indexOf(instructionName);
        if (index == -1) {
            return null;
        }
        if (index < 0 || index >= this.args.length - 1) {
            return null;
        }
        return this.get(index + 1);
    }

    public String toString() {
        return Arrays.toString(this.args);
    }

    protected boolean isProperty(String text) {
        return text.startsWith("--") && text.indexOf("=") != -1;
    }

    protected Pair<String, String> toProperty(String text) {
        if (text.startsWith("--")) {
            return StringUtils.parseKV(text.substring(2), "=");
        }
        return StringUtils.parseKV(text, "=");
    }

    public String getProperty(String key) {
        for (String value : this.args) {
            Pair<String, String> keyValuePair;
            if (!this.isProperty(value) || (keyValuePair = this.toProperty(value)) == null || !keyValuePair.getKey().equals(key)) continue;
            return keyValuePair.getValue();
        }
        return null;
    }

    @Override
    public Value get(String key) {
        String value = this.getProperty(key);
        return Value.of(value);
    }

    @Override
    public Iterator<String> iterator() {
        return new PropertyIterator();
    }

    @Override
    public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    @Nullable
    public OptionalInt getPort() {
        Value port = this.getNextValue("-p");
        return port != null && port.isPresent() ? OptionalInt.of(port.getAsInt()) : OptionalInt.empty();
    }

    private final class PropertyIterator
    implements Iterator<String> {
        private int index = 0;

        private PropertyIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < MainArgs.this.args.length) {
                String value = MainArgs.this.args[this.index];
                if (value == null) continue;
                return MainArgs.this.isProperty(value);
            }
            return false;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Pair<String, String> keyValuePair = MainArgs.this.toProperty(MainArgs.this.args[this.index]);
            ++this.index;
            return keyValuePair.getKey();
        }
    }
}

