/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event;

import io.basc.framework.event.BroadcastEventRegistry;
import io.basc.framework.event.ConvertObservable;
import io.basc.framework.event.EmptyObservable;
import io.basc.framework.event.FilterObservable;
import io.basc.framework.event.IfAbsentObservable;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.util.Optional;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Observable<T>
extends Optional<T>,
BroadcastEventRegistry<ObservableChangeEvent<T>> {
    public static <U> Observable<U> empty() {
        return new EmptyObservable();
    }

    @Override
    default public <U> Observable<U> convert(Function<? super T, ? extends U> converter) {
        Objects.requireNonNull(converter);
        return new ConvertObservable<T, U>(this, converter);
    }

    @Override
    default public Observable<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return new FilterObservable<T>(this, predicate);
    }

    @Override
    default public Observable<T> ifAbsentGet(Supplier<? extends T> other) {
        Objects.requireNonNull(other);
        return new IfAbsentObservable<T>(this, other);
    }

    @Override
    default public Observable<T> ifAbsent(T other) {
        return this.ifAbsentGet(() -> other);
    }

    @Override
    default public <U> Observable<U> map(Function<? super T, ? extends U> mapper) {
        return this.convert((T e) -> e == null ? null : mapper.apply(e));
    }
}

