/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event.support;

import io.basc.framework.event.EventDispatcher;
import io.basc.framework.event.EventListener;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Registration;
import io.basc.framework.util.Select;
import io.basc.framework.util.Selector;
import io.basc.framework.util.SharedResultSet;
import java.util.concurrent.Executor;

public class StandardEventDispatcher<T>
implements EventDispatcher<T> {
    private final SharedResultSet<EventListener<T>> listeners = new SharedResultSet();
    private final Select<EventListener<T>> select;
    private final Executor executor;

    public StandardEventDispatcher(@Nullable Selector<EventListener<T>> selector, @Nullable Executor executor) {
        this.select = new Select<EventListener<T>>(this.listeners, selector);
        this.executor = executor;
    }

    @Override
    public Registration registerListener(EventListener<T> eventListener) {
        Assert.requiredArgument(eventListener != null, "eventListener");
        return this.listeners.register(eventListener);
    }

    @Override
    public void publishEvent(T event) {
        if (this.executor == null) {
            this.syncPublishEvent(event);
        } else {
            this.executor.execute(() -> this.syncPublishEvent(event));
        }
    }

    public void syncPublishEvent(T event) {
        this.select.consume(e -> e.onEvent(event));
    }

    public SharedResultSet<EventListener<T>> getListeners() {
        return this.listeners;
    }

    public Select<EventListener<T>> getSelect() {
        return this.select;
    }

    public void unregisterListeners() {
        this.listeners.clear();
    }
}

