/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory;

import io.basc.framework.factory.BeanFactory;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Optional;
import io.basc.framework.util.Return;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FactoryLoader {
    private static volatile Map<ClassLoader, BeanFactory> FACTORY_MAP = new HashMap<ClassLoader, BeanFactory>(4);
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static BeanFactory bind(ClassLoader classLoader, BeanFactory beanFactory) {
        BeanFactory source;
        Lock lock = LOCK.writeLock();
        lock.lock();
        try {
            source = FACTORY_MAP.put(classLoader, beanFactory);
        }
        finally {
            lock.unlock();
        }
        if (source == null) {
            source = FactoryLoader.getBeanFactory(classLoader.getParent());
        }
        return FactoryLoader.getParentBeanFactory(source, beanFactory).orElse(null);
    }

    public static Return<BeanFactory> getParentBeanFactory(BeanFactory source, BeanFactory exclude) {
        for (BeanFactory factory = source; factory != null; factory = (BeanFactory)factory.getParent()) {
            if (factory != exclude) continue;
            return Return.error("BeanFactory cannot be nested circularly", factory.getParent());
        }
        return Return.success(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T extends BeanFactory> T get(ClassLoader classLoader, Class<T> type) {
        Assert.requiredArgument(type != null, "type");
        if (classLoader == null) {
            return null;
        }
        Lock lock = LOCK.readLock();
        ClassLoader use = classLoader;
        BeanFactory beanFactory = null;
        while (use != null && beanFactory == null) {
            lock.lock();
            try {
                beanFactory = FACTORY_MAP.get(use);
            }
            finally {
                lock.unlock();
            }
            if (beanFactory != null && type.isInstance(beanFactory)) {
                return (T)beanFactory;
            }
            if (beanFactory != null) continue;
            use = classLoader.getParent();
        }
        return null;
    }

    public static BeanFactory getBeanFactory(ClassLoader classLoader) {
        return FactoryLoader.get(classLoader, BeanFactory.class);
    }

    @Nullable
    public static BeanFactory getBeanFactory() {
        return FactoryLoader.getBeanFactory(Thread.currentThread().getContextClassLoader());
    }

    public static <T> Optional<T> getInstance(Class<? extends T> type) {
        BeanFactory beanFactory = FactoryLoader.getBeanFactory(type.getClassLoader());
        if (beanFactory == null || !beanFactory.isInstance(type)) {
            return Optional.empty();
        }
        return Optional.of(beanFactory.getInstance(type));
    }

    public static Optional<Object> getInstance(String name, ClassLoader classLoader) {
        BeanFactory beanFactory = FactoryLoader.getBeanFactory(classLoader);
        if (beanFactory == null || !beanFactory.isInstance(name)) {
            return Optional.empty();
        }
        return Optional.of(beanFactory.getInstance(name));
    }
}

