/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory;

import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.AnyInheriterRegistry;
import io.basc.framework.util.Source;
import io.basc.framework.util.Status;

public class InheritableThreadLocalConfigurator<T>
extends InheritableThreadLocal<T>
implements Configurable {
    private static Logger logger = LoggerFactory.getLogger(InheritableThreadLocalConfigurator.class);
    private final Class<T> serviceClass;
    private boolean configured;
    private volatile T defaultService;

    public InheritableThreadLocalConfigurator(Class<T> serviceClass) {
        this(serviceClass, null);
    }

    public InheritableThreadLocalConfigurator(Class<T> serviceClass, @Nullable ServiceLoaderFactory serviceLoaderFactory) {
        this.serviceClass = serviceClass;
        if (serviceLoaderFactory != null) {
            this.configure(serviceLoaderFactory);
        }
        AnyInheriterRegistry.global().register(this);
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        if (this.setDefaultService(() -> serviceLoaderFactory.getServiceLoader(this.serviceClass).first()).isSuccess()) {
            this.configured = true;
        }
    }

    public Status setDefaultService(Source<? extends T, ? extends Throwable> source) {
        try {
            T service = source.get();
            if (service == null) {
                return Status.error(1L, "Get configuration is empty");
            }
            this.defaultService = service;
            this.configured = true;
            logger.info("Set the default {} to {}", this.serviceClass, service);
            return Status.success();
        }
        catch (Throwable e) {
            logger.error(e, "Failed to set the default {}", this.serviceClass);
            return Status.error(2L, e.getMessage());
        }
    }

    public InheritableThreadLocalConfigurator<T> ifAbsentDefaultService(Source<? extends T, ? extends Throwable> source) {
        this.setDefaultService(source);
        return this;
    }

    @Nullable
    public T getDefaultService() {
        return this.defaultService;
    }

    public void setDefaultService(T defaultService) {
        this.defaultService = defaultService;
    }

    public Class<T> getServiceClass() {
        return this.serviceClass;
    }

    @Override
    protected T initialValue() {
        if (logger.isDebugEnabled()) {
            logger.debug("The initial {} is {}", this.serviceClass, this.defaultService);
        }
        return this.defaultService;
    }

    @Override
    public void set(T value) {
        if (logger.isDebugEnabled()) {
            logger.debug("Set the current {} to {}", this.serviceClass, value);
        }
        super.set(value);
    }

    @Override
    public void remove() {
        if (logger.isDebugEnabled()) {
            logger.debug("Remove the current {}", this.serviceClass);
        }
        super.remove();
    }

    public String toString() {
        return "The configuration of " + this.serviceClass + " is " + this.defaultService + " by default, and is currently " + this.get();
    }
}

