/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.factory.InstanceFactory;
import io.basc.framework.factory.support.InstanceIterator;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.ServiceLoader;
import io.basc.framework.value.Value;
import io.basc.framework.value.ValueFactory;
import java.util.Arrays;

public class ConfigServiceLoader<S>
implements ServiceLoader<S> {
    private final Class<S> serviceClass;
    private final ValueFactory<String> configFactory;
    private final InstanceFactory instanceFactory;
    private volatile String[] names;

    public ConfigServiceLoader(Class<S> serviceClass, ValueFactory<String> configFactory, InstanceFactory instanceFactory) {
        Assert.requiredArgument(serviceClass != null, "serviceClass");
        Assert.requiredArgument(configFactory != null, "configFactory");
        Assert.requiredArgument(instanceFactory != null, "instanceFactory");
        this.serviceClass = serviceClass;
        this.configFactory = configFactory;
        this.instanceFactory = instanceFactory;
    }

    public String[] getNames() {
        Value value = this.configFactory.get(this.serviceClass.getName());
        if (value == null) {
            return new String[0];
        }
        String[] names = value.getAsObject(String[].class);
        if (names == null) {
            return new String[0];
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        ConfigServiceLoader configServiceLoader = this;
        synchronized (configServiceLoader) {
            this.names = this.getNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor<S> iterator() {
        if (this.names == null) {
            ConfigServiceLoader configServiceLoader = this;
            synchronized (configServiceLoader) {
                if (this.names == null) {
                    this.names = this.getNames();
                }
            }
        }
        return Cursor.of(new InstanceIterator(this.instanceFactory, Arrays.asList(this.names).iterator()));
    }
}

