/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.aop.Aop;
import io.basc.framework.aop.MethodInterceptor;
import io.basc.framework.aop.Proxy;
import io.basc.framework.aop.support.ConfigurableMethodInterceptor;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.factory.BeanDefinition;
import io.basc.framework.factory.BeanPostProcessor;
import io.basc.framework.factory.BeanResolver;
import io.basc.framework.factory.BeansException;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.factory.InstanceException;
import io.basc.framework.factory.ParametersFactory;
import io.basc.framework.factory.support.RuntimeBean;
import io.basc.framework.lang.NotFoundException;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.mapper.ExecutableParameterDescriptorsIterator;
import io.basc.framework.mapper.ParameterDescriptor;
import io.basc.framework.mapper.ParameterDescriptors;
import io.basc.framework.mapper.ParameterUtils;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class DefaultBeanDefinition
implements BeanDefinition,
Cloneable {
    private static Logger logger = LoggerFactory.getLogger(DefaultBeanDefinition.class);
    private Aop aop;
    private final ConfigurableServices<BeanPostProcessor> dependenceProcessors = new ConfigurableServices<BeanPostProcessor>(BeanPostProcessor.class);
    private final ConfigurableServices<BeanPostProcessor> destroyProcessors = new ConfigurableServices<BeanPostProcessor>(BeanPostProcessor.class);
    private BeanResolver beanResolver;
    private String id;
    private final ConfigurableServices<BeanPostProcessor> initProcessors = new ConfigurableServices<BeanPostProcessor>(BeanPostProcessor.class);
    private boolean isNew = true;
    private final ConfigurableMethodInterceptor methodInterceptors = new ConfigurableMethodInterceptor();
    private Collection<String> names;
    private volatile ParameterDescriptors parameterDescriptors;
    private Boolean singleton;
    private TypeDescriptor typeDescriptor;
    private Boolean external;

    public DefaultBeanDefinition(TypeDescriptor typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
    }

    private boolean canCreateInterfaceInsance() {
        return this.typeDescriptor.getType().isInterface() && this.isAopEnable(this.getBeanResolver());
    }

    public Aop getAop() {
        return this.aop;
    }

    public void setAop(Aop aop) {
        this.aop = aop;
    }

    protected ParameterDescriptors checkParameterDescriptors(ParametersFactory parametersFactory) {
        for (ParameterDescriptors parameterDescriptors : this) {
            if (parameterDescriptors.size() != 0 && (parametersFactory == null || !parametersFactory.isAccept(parameterDescriptors))) continue;
            return parameterDescriptors;
        }
        return null;
    }

    public BeanDefinition clone() {
        try {
            DefaultBeanDefinition beanDefinition = (DefaultBeanDefinition)super.clone();
            beanDefinition.setNew(false);
            return beanDefinition;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object create() throws InstanceException {
        ParameterDescriptors parameterDescriptors;
        BeanResolver beanResolver;
        Aop aop = this.getAop();
        if (aop != null && this.canCreateInterfaceInsance()) {
            return this.createProxy(aop, this.typeDescriptor, null).create();
        }
        if (!this.isInstance()) {
            throw new UnsupportedException(this.getTypeDescriptor().getName());
        }
        return this.createInternal(beanResolver, this.typeDescriptor, parameterDescriptors, (parameterDescriptors = this.getParameterDescriptors(beanResolver = this.getBeanResolver())).size() == 0 ? new Object[]{} : beanResolver.getParameters(parameterDescriptors));
    }

    @Override
    public Object create(Class<?>[] parameterTypes, Object[] params) throws InstanceException {
        ParameterDescriptors parameterDescriptors = this.getParameterDescriptors(parameterTypes);
        if (parameterDescriptors == null) {
            throw new NotFoundException(this.typeDescriptor + "\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6784\u9020\u65b9\u6cd5");
        }
        return this.createInternal(this.getBeanResolver(), this.typeDescriptor, parameterDescriptors, params);
    }

    @Override
    public Object create(Object ... params) throws InstanceException {
        BeanResolver beanResolver = this.getBeanResolver();
        ParameterDescriptors parameterDescriptors = this.getParameterDescriptors(beanResolver, params);
        if (parameterDescriptors == null) {
            throw new NotFoundException(this.getTypeDescriptor() + "\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6784\u9020\u65b9\u6cd5");
        }
        return this.createInternal(beanResolver, this.typeDescriptor, parameterDescriptors, params);
    }

    protected Proxy createInstanceProxy(Aop aop, Object instance, Class<?> targetClass, Class<?>[] interfaces) {
        Object[] interfacesToUse = interfaces;
        interfacesToUse = ArrayUtils.isEmpty(interfacesToUse) ? RuntimeBean.PROXY_INTERFACES : ArrayUtils.merge(interfacesToUse, RuntimeBean.PROXY_INTERFACES);
        ConfigurableMethodInterceptor interceptors = new ConfigurableMethodInterceptor();
        interceptors.addMethodInterceptor(new RuntimeBean.RuntimeBeanMethodInterceptor(this));
        interceptors.addMethodInterceptor(this.methodInterceptors);
        return aop.getProxy(targetClass, instance, interfaces, (MethodInterceptor)interceptors);
    }

    protected Object createInternal(BeanResolver beanResolver, TypeDescriptor typeDescriptor, ParameterDescriptors parameterDescriptors, Object[] params) {
        Aop aop = this.getAop();
        if (aop != null && this.isAopEnable(typeDescriptor, beanResolver)) {
            return this.createProxyInstance(aop, typeDescriptor, parameterDescriptors.getTypes(), params);
        }
        Constructor<?> constructor = ReflectionUtils.getDeclaredConstructor(typeDescriptor.getType(), parameterDescriptors.getTypes());
        Object instance = ReflectionUtils.newInstance(constructor, params);
        return instance;
    }

    protected Proxy createProxy(Aop aop, TypeDescriptor typeDescriptor, Class<?>[] interfaces) {
        Object[] interfacesToUse = interfaces;
        interfacesToUse = ArrayUtils.isEmpty(interfacesToUse) ? RuntimeBean.PROXY_INTERFACES : ArrayUtils.merge(interfacesToUse, RuntimeBean.PROXY_INTERFACES);
        RuntimeBean.RuntimeBeanMethodInterceptor interceptor = new RuntimeBean.RuntimeBeanMethodInterceptor(this);
        if (this.methodInterceptors.isEmpty()) {
            return aop.getProxy(typeDescriptor.getType(), (Class<?>[])interfacesToUse, interceptor);
        }
        ConfigurableMethodInterceptor interceptors = new ConfigurableMethodInterceptor();
        interceptors.addMethodInterceptor(interceptor);
        interceptors.addMethodInterceptor(this.getMethodInterceptors());
        return aop.getProxy(typeDescriptor.getType(), (Class<?>[])interfacesToUse, interceptors);
    }

    protected Object createProxyInstance(Aop aop, TypeDescriptor typeDescriptor, Class<?>[] parameterTypes, Object[] args) {
        if (typeDescriptor.getType().isInterface() && this.methodInterceptors.isEmpty()) {
            logger.warn("empty filter: {}", typeDescriptor.getName());
        }
        Proxy proxy = this.createProxy(aop, typeDescriptor, null);
        return proxy.create(parameterTypes, args);
    }

    @Override
    public void dependence(Object instance) throws BeansException {
        for (BeanPostProcessor processor : this.dependenceProcessors) {
            processor.processPostBean(instance, this);
        }
    }

    @Override
    public void destroy(Object instance) throws BeansException {
        for (BeanPostProcessor processor : this.destroyProcessors) {
            processor.processPostBean(instance, this);
        }
    }

    public ConfigurableServices<BeanPostProcessor> getDependenceProcessors() {
        return this.dependenceProcessors;
    }

    public ConfigurableServices<BeanPostProcessor> getDestroyProcessors() {
        return this.destroyProcessors;
    }

    public BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    @Override
    public String getId() {
        BeanResolver beanResolver;
        String id = this.id;
        if (StringUtils.isEmpty(id) && (beanResolver = this.getBeanResolver()) != null) {
            id = beanResolver.getId(this.typeDescriptor);
        }
        return StringUtils.isEmpty(id) ? this.getDefaultId() : id;
    }

    protected String getDefaultId() {
        return this.typeDescriptor.getType().getName();
    }

    public ConfigurableServices<BeanPostProcessor> getInitProcessors() {
        return this.initProcessors;
    }

    public ConfigurableMethodInterceptor getMethodInterceptors() {
        return this.methodInterceptors;
    }

    @Override
    public Collection<String> getNames() {
        BeanResolver beanResolver;
        Collection<String> names = this.names;
        if (CollectionUtils.isEmpty(names) && (beanResolver = this.getBeanResolver()) != null) {
            names = beanResolver.getNames(this.typeDescriptor);
        }
        return CollectionUtils.isEmpty(names) ? Collections.emptyList() : names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterDescriptors getParameterDescriptors(ParametersFactory parametersFactory) {
        if (this.parameterDescriptors == null) {
            DefaultBeanDefinition defaultBeanDefinition = this;
            synchronized (defaultBeanDefinition) {
                ParameterDescriptors parameterDescriptors;
                if (this.parameterDescriptors == null && (parameterDescriptors = this.checkParameterDescriptors(parametersFactory)) != null) {
                    this.parameterDescriptors = parameterDescriptors;
                }
            }
        }
        return this.parameterDescriptors;
    }

    protected ParameterDescriptors getParameterDescriptors(Class<?>[] parameterTypes) {
        for (ParameterDescriptors parameterDescriptors : this) {
            if (!ParameterUtils.isisAssignable(parameterDescriptors, parameterTypes)) continue;
            return parameterDescriptors;
        }
        return null;
    }

    protected boolean isAssignableValue(BeanResolver beanResolver, ParameterDescriptors parameterDescriptors, Object[] params) {
        if (parameterDescriptors.size() == 0 ^ ArrayUtils.isEmpty(params)) {
            return false;
        }
        if (parameterDescriptors.size() != params.length) {
            return false;
        }
        int index = 0;
        for (ParameterDescriptor parameterDescriptor : parameterDescriptors) {
            Object value;
            if ((value = params[index++]) == null && beanResolver != null && beanResolver.isNullable(parameterDescriptor)) {
                return false;
            }
            if (ClassUtils.isAssignableValue(parameterDescriptor.getType(), value)) continue;
            return false;
        }
        return true;
    }

    protected ParameterDescriptors getParameterDescriptors(BeanResolver beanResolver, Object[] params) {
        for (ParameterDescriptors parameterDescriptors : this) {
            if (!this.isAssignableValue(beanResolver, parameterDescriptors, params)) continue;
            return parameterDescriptors;
        }
        return null;
    }

    public Boolean getSingleton() {
        return this.singleton;
    }

    protected String getStringDescribe() {
        return ReflectionUtils.toString(this);
    }

    @Override
    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public void init(Object instance) throws BeansException {
        for (BeanPostProcessor processor : this.initProcessors) {
            processor.processPostBean(instance, this);
        }
    }

    public boolean isAopEnable(TypeDescriptor typeDescriptor) {
        return this.isAopEnable(typeDescriptor, this.beanResolver);
    }

    public boolean isAopEnable(BeanResolver beanResolver) {
        return this.isAopEnable(this.typeDescriptor, beanResolver);
    }

    public boolean isAopEnable(TypeDescriptor typeDescriptor, BeanResolver beanResolver) {
        return this.getAop() != null && (!this.methodInterceptors.isEmpty() || beanResolver != null && beanResolver.isAopEnable(typeDescriptor));
    }

    @Override
    public boolean isInstance() {
        return this.canCreateInterfaceInsance() || this.isInstance(this.isAopEnable(this.getBeanResolver()));
    }

    public boolean isInstance(boolean supportAbstract) {
        if (!supportAbstract && Modifier.isAbstract(this.getTypeDescriptor().getType().getModifiers())) {
            return false;
        }
        return this.getParameterDescriptors(this.getBeanResolver()) != null;
    }

    @Override
    public boolean isInstance(Class<?>[] parameterTypes) {
        return this.getParameterDescriptors(parameterTypes) != null;
    }

    @Override
    public boolean isInstance(Object ... params) {
        return this.getParameterDescriptors(this.getBeanResolver(), params) != null;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public boolean isSingleton() {
        BeanResolver beanResolver = this.getBeanResolver();
        if (this.singleton == null && beanResolver != null) {
            return beanResolver.isSingleton(this.typeDescriptor);
        }
        return this.singleton == null ? true : this.singleton;
    }

    @Override
    public Iterator<ParameterDescriptors> iterator() {
        return new ExecutableParameterDescriptorsIterator(this.getTypeDescriptor().getType());
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNames(Collection<String> names) {
        this.names = names;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void setSingleton(Boolean singleton) {
        this.singleton = singleton;
    }

    public final String toString() {
        return this.getClass().getName() + "[" + this.getStringDescribe() + "]";
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    @Override
    public boolean isExternal() {
        if (this.external == null && this.beanResolver != null) {
            return this.beanResolver.isExternal(this.typeDescriptor);
        }
        return this.external == null ? false : this.external;
    }
}

