/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.event.BroadcastEventDispatcher;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.support.StandardBroadcastEventDispatcher;
import io.basc.framework.factory.BeanDefinition;
import io.basc.framework.factory.BeanDefinitionAware;
import io.basc.framework.factory.BeanLifecycleEvent;
import io.basc.framework.factory.BeanLifecycleManager;
import io.basc.framework.factory.BeanPostProcessor;
import io.basc.framework.factory.ConfigurableBeanResolver;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.factory.DefaultParameterFactoryAware;
import io.basc.framework.factory.Destroy;
import io.basc.framework.factory.FactoryException;
import io.basc.framework.factory.Init;
import io.basc.framework.factory.support.DefaultBeanDefinitionRegistry;
import io.basc.framework.factory.support.RuntimeBean;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Registration;
import java.util.Collection;

public class DefaultBeanLifeCycleManager
extends DefaultBeanDefinitionRegistry
implements BeanLifecycleManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultBeanLifeCycleManager.class);
    private final ConfigurableServices<BeanPostProcessor> dependenceProcessors = new ConfigurableServices<BeanPostProcessor>(BeanPostProcessor.class);
    private final ConfigurableServices<BeanPostProcessor> destroyProcessors = new ConfigurableServices<BeanPostProcessor>(BeanPostProcessor.class);
    private final BroadcastEventDispatcher<BeanLifecycleEvent> eventDispatcher = new StandardBroadcastEventDispatcher<BeanLifecycleEvent>();
    private final ConfigurableServices<BeanPostProcessor> initProcessors = new ConfigurableServices<BeanPostProcessor>(BeanPostProcessor.class);
    private final ConfigurableBeanResolver beanResolver = new ConfigurableBeanResolver();

    protected void _dependence(Object instance, BeanDefinition definition) throws FactoryException {
        if (instance instanceof BeanDefinitionAware) {
            ((BeanDefinitionAware)instance).setBeanDefinition(definition);
        }
        if (instance instanceof DefaultParameterFactoryAware) {
            ((DefaultParameterFactoryAware)instance).setDefaultParameterFactory(this.beanResolver);
        }
    }

    protected void _destroy(Object instance, BeanDefinition definition) throws FactoryException {
        if (instance == null) {
            return;
        }
        if (instance instanceof Destroy) {
            try {
                ((Destroy)instance).destroy();
            }
            catch (Throwable e) {
                if (e instanceof FactoryException) {
                    throw (FactoryException)e;
                }
                throw new FactoryException(definition.getId(), e);
            }
        }
    }

    protected void _init(Object instance, BeanDefinition definition) throws FactoryException {
        if (instance == null) {
            return;
        }
        if (instance instanceof Init) {
            try {
                ((Init)instance).init();
            }
            catch (Throwable e) {
                if (e instanceof FactoryException) {
                    throw (FactoryException)e;
                }
                throw new FactoryException(definition.getId(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependence(Object instance, BeanDefinition definition) throws FactoryException {
        if (definition == null) {
            return;
        }
        RuntimeBean runtimeBean = RuntimeBean.getRuntimeBean(instance);
        if (runtimeBean != null && !runtimeBean._dependence()) {
            return;
        }
        if (definition.isExternal()) {
            definition.dependence(instance);
        }
        try {
            this.publishEvent(new BeanLifecycleEvent(definition, instance, BeanLifecycleEvent.Step.BEFORE_DEPENDENCE));
        }
        finally {
            Collection<BeanPostProcessor> processors;
            if (this.beanResolver != null && (processors = this.beanResolver.resolveDependenceProcessors(definition.getTypeDescriptor().narrow(instance))) != null) {
                for (BeanPostProcessor processor : processors) {
                    processor.processPostBean(instance, definition);
                }
            }
            definition.init(instance);
            for (BeanPostProcessor processor : this.dependenceProcessors) {
                processor.processPostBean(instance, definition);
            }
            this._dependence(instance, definition);
            this.publishEvent(new BeanLifecycleEvent(definition, instance, BeanLifecycleEvent.Step.AFTER_DEPENDENCE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(Object instance, BeanDefinition definition) throws FactoryException {
        if (definition == null) {
            return;
        }
        RuntimeBean runtimeBean = RuntimeBean.getRuntimeBean(instance);
        if (runtimeBean != null && !runtimeBean._destroy()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("destroy {}", definition);
        }
        if (definition.isExternal()) {
            definition.destroy(instance);
            return;
        }
        try {
            this.publishEvent(new BeanLifecycleEvent(definition, instance, BeanLifecycleEvent.Step.BEFORE_DESTROY));
        }
        finally {
            Collection<BeanPostProcessor> processors;
            this._destroy(instance, definition);
            for (BeanPostProcessor processor : this.destroyProcessors) {
                processor.processPostBean(instance, definition);
            }
            definition.destroy(instance);
            if (this.beanResolver != null && (processors = this.beanResolver.resolveDestroyProcessors(definition.getTypeDescriptor().narrow(instance))) != null) {
                for (BeanPostProcessor processor : processors) {
                    processor.processPostBean(instance, definition);
                }
            }
            this.publishEvent(new BeanLifecycleEvent(definition, instance, BeanLifecycleEvent.Step.AFTER_DESTROY));
        }
    }

    public ConfigurableServices<BeanPostProcessor> getDependenceProcessors() {
        return this.dependenceProcessors;
    }

    public ConfigurableServices<BeanPostProcessor> getDestroyProcessors() {
        return this.destroyProcessors;
    }

    public ConfigurableServices<BeanPostProcessor> getInitProcessors() {
        return this.initProcessors;
    }

    public ConfigurableBeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Object instance, BeanDefinition definition) throws FactoryException {
        if (definition == null) {
            return;
        }
        RuntimeBean runtimeBean = RuntimeBean.getRuntimeBean(instance);
        if (runtimeBean != null && !runtimeBean._init()) {
            return;
        }
        if (definition.isExternal()) {
            definition.init(instance);
            return;
        }
        try {
            this.publishEvent(new BeanLifecycleEvent(definition, instance, BeanLifecycleEvent.Step.BEFORE_INIT));
        }
        finally {
            Collection<BeanPostProcessor> processors;
            if (this.beanResolver != null && (processors = this.beanResolver.resolveInitProcessors(definition.getTypeDescriptor().narrow(instance))) != null) {
                for (BeanPostProcessor processor : processors) {
                    processor.processPostBean(instance, definition);
                }
            }
            definition.init(instance);
            for (BeanPostProcessor processor : this.initProcessors) {
                processor.processPostBean(instance, definition);
            }
            this._init(instance, definition);
            this.publishEvent(new BeanLifecycleEvent(definition, instance, BeanLifecycleEvent.Step.AFTER_INIT));
        }
    }

    @Override
    public void publishEvent(BeanLifecycleEvent event) {
        this.eventDispatcher.publishEvent(event);
    }

    @Override
    public Registration registerListener(EventListener<BeanLifecycleEvent> eventListener) {
        return this.eventDispatcher.registerListener(eventListener);
    }
}

