/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.factory.BeanDefinition;
import io.basc.framework.factory.FactoryException;
import io.basc.framework.factory.InstanceFactory;
import io.basc.framework.factory.support.DefaultSingletonRegistry;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.Creator;
import io.basc.framework.util.Processor;
import io.basc.framework.util.Return;
import io.basc.framework.util.Source;

public class DefaultInstanceFactory
extends DefaultSingletonRegistry
implements InstanceFactory {
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        Assert.requiredArgument(classLoader != null, "classLoader");
        this.classLoader = classLoader;
    }

    public <T, E extends Throwable> T getInstance(BeanDefinition definition, Creator<? extends T, ? extends E> creater) throws E {
        return this.getInstance(definition, creater, true).get();
    }

    public <T, E extends Throwable> Return<T> getInstance(BeanDefinition definition, Creator<? extends T, ? extends E> creater, boolean postProcessBean) throws E {
        if (definition.isSingleton()) {
            return this.getSingleton(definition.getId(), creater, postProcessBean);
        }
        T instance = creater.create();
        if (postProcessBean) {
            this.processPostBean(instance, definition);
        }
        return Return.success(instance);
    }

    public <T, E extends Throwable> Return<T> getInstance(String name, Processor<? super BeanDefinition, ? extends T, ? extends E> createProcessor, boolean postProcessBean) throws E {
        Object object = this.getSingleton(name);
        if (object != null) {
            return Return.success(object);
        }
        BeanDefinition definition = this.getDefinition(name);
        if (definition == null) {
            return null;
        }
        return this.getInstance(definition, () -> createProcessor.process(definition), postProcessBean);
    }

    public <T, E extends Throwable> T getInstance(String name, Processor<BeanDefinition, T, E> createProcessor) throws E {
        return this.getInstance(name, createProcessor, true).get();
    }

    @Override
    public <T> T getInstance(Class<? extends T> clazz) throws FactoryException {
        return (T)this.getInstance(clazz.getName());
    }

    @Override
    public Object getInstance(String name) throws FactoryException {
        return this.getInstance(name, (BeanDefinition e) -> e.create());
    }

    @Override
    public boolean isInstance(Class<?> clazz) {
        return this.isInstance(clazz.getName());
    }

    public <E extends Throwable> boolean isInstance(BeanDefinition definition, Source<Boolean, E> processor) throws E {
        if (definition == null) {
            return false;
        }
        if (this.containsSingleton(definition.getId())) {
            return true;
        }
        Boolean b = processor.get();
        return b == null ? false : b;
    }

    public <E extends Throwable> boolean isInstance(String name, Processor<BeanDefinition, Boolean, E> processor) throws E {
        if (this.containsSingleton(name)) {
            return true;
        }
        BeanDefinition definition = this.getDefinition(name);
        return this.isInstance(definition, () -> (Boolean)processor.process(definition));
    }

    @Override
    public boolean isInstance(String name) {
        return this.isInstance(name, (BeanDefinition e) -> e.isInstance());
    }

    public boolean isSingleton(Class<?> clazz) {
        return this.isSingleton(clazz.getName());
    }

    public boolean isSingleton(String name) {
        if (this.containsSingleton(name)) {
            return true;
        }
        BeanDefinition definition = this.getDefinition(name);
        if (definition == null) {
            return false;
        }
        return this.containsSingleton(definition.getId()) || definition.isSingleton();
    }
}

