/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.event.EventListener;
import io.basc.framework.factory.BeanDefinition;
import io.basc.framework.factory.BeanLifecycleEvent;
import io.basc.framework.factory.BeanPostProcessor;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.factory.Destroy;
import io.basc.framework.factory.FactoryException;
import io.basc.framework.factory.SingletonFactory;
import io.basc.framework.factory.SingletonRegistry;
import io.basc.framework.factory.support.DefaultBeanLifeCycleManager;
import io.basc.framework.factory.support.EmptyBeanDefinition;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.Creator;
import io.basc.framework.util.Registration;
import io.basc.framework.util.Return;
import io.basc.framework.util.StandardReturn;
import io.basc.framework.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public class DefaultSingletonRegistry
extends DefaultBeanLifeCycleManager
implements SingletonRegistry,
BeanPostProcessor,
Destroy {
    private static Logger logger = LoggerFactory.getLogger(DefaultSingletonRegistry.class);
    private final ConfigurableServices<BeanPostProcessor> beanPostProcessors = new ConfigurableServices<BeanPostProcessor>(BeanPostProcessor.class);
    private volatile Map<String, SingletonObject<?>> singletionMap = new LinkedHashMap();
    private SingletonFactory parentSingletonFactory;

    @Nullable
    public SingletonFactory getParentSingletonFactory() {
        return this.parentSingletonFactory;
    }

    public void setParentSingletonFactory(SingletonFactory parentSingletonFactory) {
        this.parentSingletonFactory = parentSingletonFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSingleton(String beanName, Object singletonObject) {
        Map<String, SingletonObject<?>> map = this.singletionMap;
        synchronized (map) {
            SingletonObject<Object> singleton;
            BeanDefinition definition;
            SingletonObject<?> old = this.singletionMap.get(beanName);
            if (old != null) {
                throw new IllegalStateException("Could not register object [" + singletonObject + "] under bean name '" + beanName + "': there is already object [" + old + "] bound");
            }
            if (this.containsDefinition(beanName)) {
                definition = this.getDefinition(beanName);
                singleton = new SingletonObject<Object>(singletonObject);
            } else {
                definition = new EmptyBeanDefinition(TypeDescriptor.forObject(singletonObject), beanName);
                this.registerDefinition(definition);
                singleton = new SingletonObject<Object>(singletonObject);
                singleton.setStep(BeanLifecycleEvent.Step.AFTER_INIT);
            }
            old = this.singletionMap.get(definition.getId());
            if (old != null) {
                throw new IllegalStateException("Could not register object [" + singletonObject + "] under bean name '" + beanName + "': there is already object [" + old + "] bound");
            }
            this.singletionMap.put(definition.getId(), singleton);
        }
    }

    @Override
    public BeanDefinition registerDefinition(String name, BeanDefinition beanDefinition) {
        if (this.containsSingleton(name)) {
            throw new FactoryException("Single instance[" + name + "] already exists, unable to register definition[" + beanDefinition + "]");
        }
        return super.registerDefinition(name, beanDefinition);
    }

    @Override
    public Object getSingleton(String beanName) {
        return this.getSingleton(beanName, this.getParentSingletonFactory());
    }

    public Object getSingleton(String beanName, SingletonFactory parent) {
        SingletonObject<?> instance = this.singletionMap.get(beanName);
        if (instance != null) {
            return instance.get();
        }
        BeanDefinition definition = this.getDefinition(beanName);
        if (definition == null) {
            return parent == null ? null : parent.getSingleton(beanName);
        }
        SingletonObject<?> singletonObject = this.singletionMap.get(definition.getId());
        if (singletonObject == null) {
            return parent == null ? null : parent.getSingleton(beanName);
        }
        return singletonObject.get();
    }

    @Override
    public boolean containsSingleton(String beanName) {
        if (this.singletionMap.containsKey(beanName)) {
            return true;
        }
        if (!this.containsDefinition(beanName)) {
            return false;
        }
        BeanDefinition definition = this.getDefinition(beanName);
        if (definition == null) {
            return false;
        }
        return this.singletionMap.containsKey(definition.getId());
    }

    public boolean containsSingleton(String beanName, SingletonFactory parent) {
        if (parent != null && parent.containsSingleton(beanName)) {
            return true;
        }
        if (this.singletionMap.containsKey(beanName)) {
            return true;
        }
        if (!this.containsDefinition(beanName)) {
            return false;
        }
        BeanDefinition definition = this.getDefinition(beanName);
        if (definition == null) {
            return false;
        }
        return this.singletionMap.containsKey(definition.getId());
    }

    @Override
    public String[] getSingletonNames() {
        return this.getSingletonNames(this.getParentSingletonFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSingletonNames(SingletonFactory parent) {
        Map<String, SingletonObject<?>> map = this.singletionMap;
        synchronized (map) {
            String[] array = StringUtils.toStringArray(this.singletionMap.keySet());
            return array != null || parent == null ? array : ArrayUtils.merge(this.parentSingletonFactory.getSingletonNames(), array);
        }
    }

    @Override
    public Object getSingletonMutex() {
        return this.singletionMap;
    }

    @Override
    public <T, E extends Throwable> Return<T> getSingleton(String name, Creator<? extends T, ? extends E> creater) throws E {
        return this.getSingleton(name, creater, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> Return<T> getSingleton(String name, Creator<? extends T, ? extends E> creater, boolean postProcessBean) throws E {
        Object object = this.getSingleton(name);
        boolean created = false;
        if (object == null) {
            Map<String, SingletonObject<?>> map = this.singletionMap;
            synchronized (map) {
                object = this.getSingleton(name);
                if (object == null) {
                    object = creater.create();
                    this.registerSingleton(name, object);
                    created = true;
                }
            }
        }
        if (created && postProcessBean) {
            this.processPostBean(object, this.getDefinition(name));
        }
        return new StandardReturn<Object>(created, 0L, null, object);
    }

    @Override
    public void processPostBean(Object bean, BeanDefinition definition) throws FactoryException {
        this.dependence(bean, definition);
        for (BeanPostProcessor processor : this.beanPostProcessors) {
            processor.processPostBean(bean, definition);
        }
        this.init(bean, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Map<String, SingletonObject<?>> map = this.singletionMap;
        synchronized (map) {
            String[] names = this.getSingletonNames();
            for (int i = names.length - 1; i >= 0; --i) {
                Object instance;
                BeanDefinition definition = this.getDefinition(names[i]);
                if (definition != null && (instance = this.getSingleton(definition.getId())) != null) {
                    this.destroy(instance, definition);
                }
                this.singletionMap.remove(names[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration registerListener(EventListener<BeanLifecycleEvent> eventListener) {
        Registration eventRegistration = super.registerListener(eventListener);
        for (Map.Entry<String, SingletonObject<?>> entry : this.singletionMap.entrySet()) {
            BeanDefinition definition = this.getDefinition(entry.getKey());
            if (definition == null) continue;
            SingletonObject<?> singletonObject = entry.getValue();
            for (BeanLifecycleEvent.Step step : BeanLifecycleEvent.Step.values()) {
                if (step.getOrder() >= ((SingletonObject)singletonObject).step.getOrder()) continue;
                try {
                    eventListener.onEvent(new BeanLifecycleEvent(definition, singletonObject.get(), step));
                }
                catch (Throwable e) {
                    logger.error(e, "Register listener after on bean[{}]", definition.getId());
                }
                finally {
                    ((SingletonObject)singletonObject).step = step;
                }
            }
        }
        return eventRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dependence(Object instance, BeanDefinition definition) throws FactoryException {
        if (definition == null) {
            return;
        }
        if (!definition.isSingleton()) {
            super.dependence(instance, definition);
            return;
        }
        Map<String, SingletonObject<?>> map = this.singletionMap;
        synchronized (map) {
            SingletonObject<?> singletonObject = this.singletionMap.get(definition.getId());
            if (singletonObject != null && ((SingletonObject)singletonObject).step.getOrder() >= BeanLifecycleEvent.Step.AFTER_DEPENDENCE.getOrder()) {
                return;
            }
            if (singletonObject != null) {
                singletonObject.setStep(BeanLifecycleEvent.Step.BEFORE_DEPENDENCE);
            }
            try {
                super.dependence(instance, definition);
            }
            finally {
                if (singletonObject != null) {
                    singletonObject.setStep(BeanLifecycleEvent.Step.AFTER_DEPENDENCE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void init(Object instance, BeanDefinition definition) throws FactoryException {
        if (definition == null) {
            return;
        }
        if (!definition.isSingleton()) {
            super.init(instance, definition);
            return;
        }
        Map<String, SingletonObject<?>> map = this.singletionMap;
        synchronized (map) {
            SingletonObject<?> singletonObject = this.singletionMap.get(definition.getId());
            if (singletonObject != null && ((SingletonObject)singletonObject).step.getOrder() >= BeanLifecycleEvent.Step.AFTER_INIT.getOrder()) {
                return;
            }
            if (singletonObject != null) {
                singletonObject.setStep(BeanLifecycleEvent.Step.BEFORE_INIT);
            }
            try {
                super.init(instance, definition);
            }
            finally {
                if (singletonObject != null) {
                    singletonObject.setStep(BeanLifecycleEvent.Step.AFTER_INIT);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy(Object instance, BeanDefinition definition) throws FactoryException {
        if (definition == null) {
            return;
        }
        if (!definition.isSingleton()) {
            super.destroy(instance, definition);
            return;
        }
        Map<String, SingletonObject<?>> map = this.singletionMap;
        synchronized (map) {
            SingletonObject<?> singletonObject = this.singletionMap.get(definition.getId());
            if (singletonObject != null && ((SingletonObject)singletonObject).step.getOrder() >= BeanLifecycleEvent.Step.AFTER_DESTROY.getOrder()) {
                return;
            }
            if (singletonObject != null) {
                singletonObject.setStep(BeanLifecycleEvent.Step.BEFORE_DESTROY);
            }
            try {
                super.destroy(instance, definition);
            }
            finally {
                if (singletonObject != null) {
                    singletonObject.setStep(BeanLifecycleEvent.Step.AFTER_DESTROY);
                }
            }
        }
    }

    private static class SingletonObject<T>
    implements Supplier<T> {
        private BeanLifecycleEvent.Step step = BeanLifecycleEvent.Step.BEFORE_DEPENDENCE;
        private final T instance;

        public SingletonObject(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public void setStep(BeanLifecycleEvent.Step step) {
            this.step = step;
        }

        public String toString() {
            return "setp=" + this.step + ", bean=" + this.instance;
        }
    }
}

