/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.factory.BeanResolver;
import io.basc.framework.factory.BeanResolverExtend;
import io.basc.framework.factory.InstanceFactory;
import io.basc.framework.factory.ParameterFactory;
import io.basc.framework.factory.support.AbstractParametersFactory;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.ParameterDescriptor;
import io.basc.framework.mapper.ParameterDescriptors;
import io.basc.framework.value.Value;
import java.util.Collection;
import java.util.Map;

public class InstanceParameterFactory
extends AbstractParametersFactory
implements ParameterFactory,
BeanResolverExtend {
    private final InstanceFactory instanceFactory;

    public InstanceParameterFactory(InstanceFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    public InstanceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    protected String getInstanceName(ParameterDescriptor parameterDescriptor) {
        if (this.getInstanceFactory().isInstance(parameterDescriptor.getType())) {
            return parameterDescriptor.getType().getName();
        }
        if (this.getInstanceFactory().isInstance(parameterDescriptor.getName())) {
            return parameterDescriptor.getName();
        }
        return null;
    }

    @Override
    protected boolean isAccept(ParameterDescriptors parameterDescriptors, ParameterDescriptor parameterDescriptor, int index) {
        if (parameterDescriptor.getType() == parameterDescriptors.getDeclaringClass()) {
            return false;
        }
        return this.isAccept(parameterDescriptor);
    }

    @Override
    protected Object getParameter(ParameterDescriptors parameterDescriptors, ParameterDescriptor parameterDescriptor, int index) {
        return this.getParameter(parameterDescriptor);
    }

    @Override
    public boolean isAccept(ParameterDescriptor parameterDescriptor) {
        if (Value.isBaseType(parameterDescriptor.getType()) || Collection.class.isAssignableFrom(parameterDescriptor.getType()) || Map.class.isAssignableFrom(parameterDescriptor.getType())) {
            return false;
        }
        if (parameterDescriptor.isNullable()) {
            return true;
        }
        String name = this.getInstanceName(parameterDescriptor);
        return name != null;
    }

    @Override
    public Object getParameter(ParameterDescriptor parameterDescriptor) {
        String name = this.getInstanceName(parameterDescriptor);
        return name == null ? null : this.getInstanceFactory().getInstance(name);
    }

    @Override
    public boolean isAccept(ParameterDescriptor parameterDescriptor, BeanResolver chain) {
        return this.isAccept(parameterDescriptor);
    }

    @Override
    public boolean isAccept(ParameterDescriptors parameterDescriptors, BeanResolver chain) {
        return this.isAccept(parameterDescriptors);
    }

    @Override
    public Object getParameter(ParameterDescriptor parameterDescriptor, BeanResolver chain) {
        if (this.isAccept(parameterDescriptor)) {
            return this.getParameter(parameterDescriptor);
        }
        return BeanResolverExtend.super.getParameter(parameterDescriptor, chain);
    }

    @Override
    public Object[] getParameters(ParameterDescriptors parameterDescriptors, BeanResolver chain) {
        if (this.isAccept(parameterDescriptors)) {
            return this.getParameters(parameterDescriptors);
        }
        return BeanResolverExtend.super.getParameters(parameterDescriptors, chain);
    }

    @Override
    public boolean isNullable(ParameterDescriptor parameterDescriptor, BeanResolver chain) {
        Nullable nullable = parameterDescriptor.getAnnotation(Nullable.class);
        if (nullable != null) {
            return nullable.value();
        }
        return BeanResolverExtend.super.isNullable(parameterDescriptor, chain);
    }
}

