/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.aop.MethodInterceptor;
import io.basc.framework.aop.MethodInterceptorAccept;
import io.basc.framework.core.reflect.MethodInvoker;
import io.basc.framework.factory.BeanDefinition;
import io.basc.framework.util.ArrayUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicBoolean;

public interface RuntimeBean {
    public static final Class<?>[] PROXY_INTERFACES = new Class[]{RuntimeBean.class};

    public BeanDefinition getBeanDefinition();

    public boolean _dependence();

    public boolean _init();

    public boolean _destroy();

    public static RuntimeBean getRuntimeBean(Object instance) {
        if (instance == null) {
            return null;
        }
        if (instance instanceof RuntimeBean) {
            return (RuntimeBean)instance;
        }
        return null;
    }

    public static class RuntimeBeanMethodInterceptor
    implements MethodInterceptor,
    MethodInterceptorAccept {
        private final AtomicBoolean _dependence = new AtomicBoolean();
        private final AtomicBoolean _init = new AtomicBoolean();
        private final AtomicBoolean _destroy = new AtomicBoolean();
        private final BeanDefinition beanDefinition;

        public RuntimeBeanMethodInterceptor(BeanDefinition beanDefinition) {
            this.beanDefinition = beanDefinition;
        }

        @Override
        public boolean isAccept(MethodInvoker invoker, Object[] args) {
            Method method;
            if (ArrayUtils.isEmpty(args) && (Modifier.isAbstract((method = invoker.getMethod()).getModifiers()) || Modifier.isInterface(method.getModifiers()))) {
                if (method.getName().equals("getBeanDefinition")) {
                    return true;
                }
                if (method.getName().equals("_dependence")) {
                    return true;
                }
                if (method.getName().equals("_init")) {
                    return true;
                }
                if (method.getName().equals("_destroy")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object intercept(MethodInvoker invoker, Object[] args) throws Throwable {
            Method method;
            if (ArrayUtils.isEmpty(args) && (Modifier.isAbstract((method = invoker.getMethod()).getModifiers()) || Modifier.isInterface(method.getModifiers()))) {
                if (method.getName().equals("getBeanDefinition")) {
                    return this.beanDefinition;
                }
                if (method.getName().equals("_dependence")) {
                    if (this._dependence.get()) {
                        return false;
                    }
                    return this._dependence.compareAndSet(false, true);
                }
                if (method.getName().equals("_init")) {
                    if (this._init.get()) {
                        return false;
                    }
                    return this._init.compareAndSet(false, true);
                }
                if (method.getName().equals("_destroy")) {
                    if (this._destroy.get()) {
                        return false;
                    }
                    return this._destroy.compareAndSet(false, true);
                }
            }
            return invoker.invoke(args);
        }
    }
}

