/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.factory.InstanceFactory;
import io.basc.framework.io.ResourceUtils;
import io.basc.framework.util.ClassLoaderProvider;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.DefaultClassLoaderProvider;
import io.basc.framework.util.ServiceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.ServiceConfigurationError;

public final class SpiServiceLoader<S>
extends DefaultClassLoaderProvider
implements ServiceLoader<S>,
ClassLoaderProvider {
    private static final String PREFIX = "META-INF/services/";
    private final Class<S> service;
    private ClassLoader loader;
    private final AccessControlContext acc;
    private LinkedHashMap<String, S> providers;
    private LazyIterator lookupIterator;
    private InstanceFactory instanceFactory;

    public SpiServiceLoader(Class<S> svc) {
        this(svc, (InstanceFactory)null);
    }

    public SpiServiceLoader(Class<S> svc, ClassLoader cl) {
        this(svc, (InstanceFactory)null);
        this.loader = cl;
    }

    public SpiServiceLoader(Class<S> svc, InstanceFactory instanceFactory) {
        this.service = Objects.requireNonNull(svc, "Service interface cannot be null");
        this.instanceFactory = instanceFactory;
        this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
        this.reload();
    }

    private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class<?> service, URL u, int line, String msg) throws ServiceConfigurationError {
        SpiServiceLoader.fail(service, u + ":" + line + ": " + msg);
    }

    private int parseLine(Class<?> service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                SpiServiceLoader.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                SpiServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                SpiServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!(this.providers != null && this.providers.containsKey(ln) || names.contains(ln) || this.instanceFactory != null && !this.instanceFactory.isInstance(ln))) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> parse(Class<?> service, URL u) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            SpiServiceLoader.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                SpiServiceLoader.fail(service, "Error closing configuration file", y);
            }
        }
        return names.iterator();
    }

    @Override
    public Cursor<S> iterator() {
        return Cursor.of(new Iterator<S>(){
            Iterator<Map.Entry<String, S>> knownProviders;
            {
                this.knownProviders = SpiServiceLoader.this.providers == null ? Collections.emptyIterator() : SpiServiceLoader.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.knownProviders.hasNext()) {
                    return true;
                }
                return SpiServiceLoader.this.lookupIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                return SpiServiceLoader.this.lookupIterator.next();
            }
        });
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.service.getName() + "]";
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.instanceFactory == null ? this.loader : this.instanceFactory.getClassLoader();
    }

    public InstanceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    public void setInstanceFactory(InstanceFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        if (this.providers != null) {
            SpiServiceLoader spiServiceLoader = this;
            synchronized (spiServiceLoader) {
                if (this.providers != null) {
                    this.providers.clear();
                }
            }
        }
        this.lookupIterator = new LazyIterator(this.service, this.getClassLoader());
    }

    private class LazyIterator
    implements Iterator<S> {
        private final Class<S> service;
        private final ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        String nextName = null;

        private LazyIterator(Class<S> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        private boolean hasNextService() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = SpiServiceLoader.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ResourceUtils.getSystemResources(ClassUtils.getDefaultClassLoader(), fullName) : ResourceUtils.getSystemResources(this.loader, fullName);
                }
                catch (IOException x) {
                    SpiServiceLoader.fail(this.service, "Error locating configuration files", x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = SpiServiceLoader.this.parse(this.service, this.configs.nextElement());
            }
            this.nextName = this.pending.next();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private S nextService() {
            if (!this.hasNextService()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            Class<?> c = null;
            try {
                c = ClassUtils.forName(cn, this.loader);
            }
            catch (ClassNotFoundException x) {
                SpiServiceLoader.fail(this.service, "Provider " + cn + " not found");
            }
            if (!this.service.isAssignableFrom(c)) {
                SpiServiceLoader.fail(this.service, "Provider " + cn + " not a subtype");
            }
            if (SpiServiceLoader.this.instanceFactory != null && !SpiServiceLoader.this.instanceFactory.isInstance(c)) {
                SpiServiceLoader.fail(this.service, "Provider " + cn + " not instantiation");
            }
            try {
                Object instance = SpiServiceLoader.this.instanceFactory == null ? ReflectionUtils.newInstance(c) : SpiServiceLoader.this.instanceFactory.getInstance(c);
                Object p = this.service.cast(instance);
                if (SpiServiceLoader.this.providers == null) {
                    LazyIterator lazyIterator = this;
                    synchronized (lazyIterator) {
                        if (SpiServiceLoader.this.providers == null) {
                            SpiServiceLoader.this.providers = new LinkedHashMap(8);
                            SpiServiceLoader.this.providers.put(cn, p);
                        }
                    }
                }
                return p;
            }
            catch (Throwable x) {
                SpiServiceLoader.fail(this.service, "Provider " + cn + " could not be instantiated", x);
                throw new Error();
            }
        }

        @Override
        public boolean hasNext() {
            if (SpiServiceLoader.this.acc == null) {
                return this.hasNextService();
            }
            PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return LazyIterator.this.hasNextService();
                }
            };
            return AccessController.doPrivileged(action, SpiServiceLoader.this.acc);
        }

        @Override
        public S next() {
            if (SpiServiceLoader.this.acc == null) {
                return this.nextService();
            }
            PrivilegedAction action = new PrivilegedAction<S>(){

                @Override
                public S run() {
                    return LazyIterator.this.nextService();
                }
            };
            return AccessController.doPrivileged(action, SpiServiceLoader.this.acc);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

