/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.gson;

import io.basc.framework.aop.support.ProxyUtils;
import io.basc.framework.gson.Gson;
import io.basc.framework.gson.TypeAdapter;
import io.basc.framework.gson.TypeAdapterFactory;
import io.basc.framework.gson.reflect.TypeToken;
import io.basc.framework.gson.stream.JsonReader;
import io.basc.framework.gson.stream.JsonWriter;
import io.basc.framework.json.JsonAware;
import io.basc.framework.value.Value;
import java.io.IOException;

public class ExtendGsonTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (JsonAware.class.isAssignableFrom(typeToken.getRawType()) || Value.class.isAssignableFrom(typeToken.getRawType()) || ProxyUtils.getFactory().isProxy(typeToken.getRawType())) {
                return new ExtendGsonTypeAdapter(gson);
            }
            return null;
        }
    };
    private final Gson context;

    private ExtendGsonTypeAdapter(Gson context) {
        this.context = context;
    }

    private <T> TypeAdapter<T> getTypeAdapter(Class<T> type) {
        TypeAdapter<T> typeAdapter = this.context.getAdapter(type);
        if (typeAdapter == null) {
            throw new UnsupportedOperationException("Attempted to serialize java.lang.Class: " + type + ". Forgot to register a type adapter?");
        }
        return typeAdapter;
    }

    @Override
    public void write(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (value instanceof JsonAware) {
            out.jsonValue(((JsonAware)value).toJsonString());
            return;
        }
        if (value instanceof Value) {
            Value valueToUse = ((Value)value).get();
            if (valueToUse == null) {
                out.nullValue();
                return;
            }
            TypeAdapter<?> typeAdapter = this.getTypeAdapter(valueToUse.getClass());
            typeAdapter.write(out, valueToUse);
            return;
        }
        Class<?> clazz = ProxyUtils.getFactory().getUserClass(value.getClass());
        TypeAdapter<?> typeAdapter = this.getTypeAdapter(clazz);
        typeAdapter.write(out, value);
    }

    @Override
    public Object read(JsonReader in) throws IOException {
        throw new UnsupportedOperationException("read");
    }
}

