/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http;

import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.HttpMessage;
import io.basc.framework.http.MediaType;
import io.basc.framework.net.MimeType;
import io.basc.framework.net.message.OutputMessage;

public interface HttpOutputMessage
extends OutputMessage,
HttpMessage {
    default public void setContentType(MediaType contentType) {
        String charsetName = contentType.getCharsetName();
        if (charsetName == null) {
            charsetName = this.getCharacterEncoding();
            if (charsetName == null) {
                ((HttpHeaders)this.getHeaders()).setContentType(contentType);
            } else {
                ((HttpHeaders)this.getHeaders()).setContentType(new MediaType((MimeType)contentType, charsetName));
            }
        } else {
            ((HttpHeaders)this.getHeaders()).setContentType(contentType);
        }
    }

    @Override
    default public void setContentType(MimeType contentType) {
        this.setContentType(new MediaType(contentType));
    }

    @Override
    default public void setContentLength(long contentLength) {
        ((HttpHeaders)this.getHeaders()).setContentLength(contentLength);
    }

    @Override
    default public void setCharacterEncoding(String charsetName) {
        MimeType mediaType = this.getContentType();
        if (mediaType == null) {
            return;
        }
        this.setContentType(new MediaType(mediaType, charsetName));
    }
}

