/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.MediaType;
import io.basc.framework.http.client.ClientHttpRequest;
import io.basc.framework.http.client.ClientHttpResponse;
import io.basc.framework.util.Assert;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractClientHttpRequest
implements ClientHttpRequest {
    private final HttpHeaders headers = new HttpHeaders();
    private boolean executed = false;

    @Override
    public final HttpHeaders getHeaders() {
        if (this.executed) {
            this.headers.readyOnly();
        }
        return this.headers;
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        this.assertNotExecuted();
        return this.getBodyInternal(this.headers);
    }

    @Override
    public MediaType getContentType() {
        return this.getHeaders().getContentType();
    }

    @Override
    public final ClientHttpResponse execute() throws IOException {
        this.assertNotExecuted();
        ClientHttpResponse result = this.executeInternal(this.headers);
        this.executed = true;
        return result;
    }

    protected void assertNotExecuted() {
        Assert.state(!this.executed, "ClientHttpRequest already executed");
    }

    protected abstract OutputStream getBodyInternal(HttpHeaders var1) throws IOException;

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1) throws IOException;
}

