/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.http.ContentDisposition;
import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.HttpRequest;
import io.basc.framework.http.HttpStatus;
import io.basc.framework.http.client.ClientHttpResponse;
import io.basc.framework.http.client.ClientHttpResponseExtractor;
import io.basc.framework.io.FileUtils;
import io.basc.framework.io.support.TemporaryFile;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.net.InetUtils;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.XUtils;
import java.io.File;
import java.io.IOException;

public class DownLoadResponseExtractor
implements ClientHttpResponseExtractor<File> {
    private static Logger logger = LoggerFactory.getLogger(DownLoadResponseExtractor.class);
    public static final ClientHttpResponseExtractor<File> INSTANCE = new DownLoadResponseExtractor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File execute(HttpRequest request, ClientHttpResponse response) throws IOException {
        String fileName;
        if (response.getStatusCode() != HttpStatus.OK && response.getStatusCode() != HttpStatus.NOT_MODIFIED) {
            logger.error("Unable to download:{}, status:{}, statusText:{}", request.getURI(), response.getRawStatusCode(), response.getStatusText());
            return null;
        }
        ContentDisposition contentDisposition = ((HttpHeaders)response.getHeaders()).getContentDisposition();
        String string = fileName = contentDisposition == null ? null : contentDisposition.getFilename();
        if (StringUtils.isEmpty(fileName)) {
            fileName = InetUtils.getFilename(request.getURI().getPath());
        }
        TemporaryFile file = new TemporaryFile(FileUtils.getTempDirectory() + File.separator + XUtils.getUUID() + File.separator + fileName);
        if (logger.isDebugEnabled()) {
            logger.debug("{} download to {}", request.getURI(), file.getPath());
        }
        try {
            FileUtils.copyInputStreamToFile(response.getInputStream(), file);
        }
        finally {
            file.deleteOnExit();
        }
        return file;
    }
}

