/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.http.HttpMethod;
import io.basc.framework.http.HttpRequestEntity;
import io.basc.framework.http.HttpResponseEntity;
import io.basc.framework.http.MediaType;
import io.basc.framework.http.client.ClientHttpRequest;
import io.basc.framework.http.client.ClientHttpRequestCallback;
import io.basc.framework.http.client.ClientHttpRequestFactory;
import io.basc.framework.http.client.ClientHttpResponseExtractor;
import io.basc.framework.http.client.HttpClientConfigurable;
import io.basc.framework.http.client.HttpClientException;
import io.basc.framework.http.client.HttpConnection;
import io.basc.framework.http.client.RedirectManager;
import io.basc.framework.lang.Nullable;
import io.basc.framework.net.uri.UriUtils;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Map;

public interface HttpClient
extends HttpClientConfigurable<HttpClient> {
    default public HttpConnection createConnection(HttpMethod method, URI uri) {
        return this.createConnection(method.name(), uri);
    }

    default public HttpConnection createConnection(HttpMethod method, String url) {
        return this.createConnection(method.name(), UriUtils.toUri(url));
    }

    default public HttpConnection createConnection(String httpMethod, String url) {
        return this.createConnection(httpMethod, UriUtils.toUri(url));
    }

    public HttpConnection createConnection(String var1, URI var2);

    default public HttpConnection createConnection(HttpMethod method, String uriTemplate, Map<String, ?> uriVariables) {
        return this.createConnection(method.name(), uriTemplate, uriVariables);
    }

    public HttpConnection createConnection(String var1, String var2, Map<String, ?> var3);

    default public HttpConnection createConnection(HttpMethod method, String uriTemplate, Object ... uriVariables) {
        return this.createConnection(method.name(), uriTemplate, uriVariables);
    }

    public HttpConnection createConnection(String var1, String var2, Object ... var3);

    default public <T> HttpResponseEntity<T> execute(ClientHttpRequest request, ClientHttpResponseExtractor<T> responseExtractor) throws HttpClientException, IOException {
        return this.execute(request, this.getCookieHandler(), responseExtractor);
    }

    default public <T> HttpResponseEntity<T> execute(ClientHttpRequest request, Class<T> responseType) throws HttpClientException, IOException {
        return this.execute(request, this.getCookieHandler(), TypeDescriptor.valueOf(responseType));
    }

    default public <T> HttpResponseEntity<T> execute(ClientHttpRequest request, TypeDescriptor responseType) throws HttpClientException, IOException {
        return this.execute(request, this.getCookieHandler(), responseType);
    }

    public <T> HttpResponseEntity<T> execute(ClientHttpRequest var1, @Nullable CookieHandler var2, ClientHttpResponseExtractor<T> var3) throws HttpClientException, IOException;

    default public <T> HttpResponseEntity<T> execute(ClientHttpRequest request, @Nullable CookieHandler cookieHandler, Class<? extends T> responseType) throws HttpClientException, IOException {
        return this.execute(request, cookieHandler, TypeDescriptor.valueOf(responseType));
    }

    public <T> HttpResponseEntity<T> execute(ClientHttpRequest var1, @Nullable CookieHandler var2, TypeDescriptor var3) throws HttpClientException, IOException;

    default public <T> HttpResponseEntity<T> execute(URI uri, String httpMethod, ClientHttpRequestCallback requestCallback, ClientHttpResponseExtractor<T> responseExtractor) {
        return this.execute(uri, httpMethod, this.getRequestFactory(), this.getCookieHandler(), requestCallback, this.getRedirectManager(), responseExtractor);
    }

    public <T> HttpResponseEntity<T> execute(URI var1, String var2, ClientHttpRequestFactory var3, @Nullable CookieHandler var4, ClientHttpRequestCallback var5, @Nullable RedirectManager var6, ClientHttpResponseExtractor<T> var7);

    default public <T> HttpResponseEntity<T> execute(URI uri, String httpMethod, ClientHttpRequestFactory requestFactory, @Nullable CookieHandler cookieHandler, ClientHttpRequestCallback requestCallback, @Nullable RedirectManager redirectManager, Class<? extends T> responseType) {
        return this.execute(uri, httpMethod, requestFactory, cookieHandler, requestCallback, redirectManager, TypeDescriptor.valueOf(responseType));
    }

    public <T> HttpResponseEntity<T> execute(URI var1, String var2, ClientHttpRequestFactory var3, @Nullable CookieHandler var4, ClientHttpRequestCallback var5, @Nullable RedirectManager var6, TypeDescriptor var7);

    default public <T> HttpResponseEntity<T> execute(URI uri, String httpMethod, Class<? extends T> responseType, ClientHttpRequestCallback requestCallback) {
        return this.execute(uri, httpMethod, this.getRequestFactory(), this.getCookieHandler(), requestCallback, this.getRedirectManager(), responseType);
    }

    default public <T> HttpResponseEntity<T> execute(URI uri, String httpMethod, TypeDescriptor responseType, ClientHttpRequestCallback requestCallback) {
        return this.execute(uri, httpMethod, this.getRequestFactory(), this.getCookieHandler(), requestCallback, this.getRedirectManager(), responseType);
    }

    default public <T> HttpResponseEntity<T> execute(HttpRequestEntity<?> requestEntity, ClientHttpResponseExtractor<T> responseExtractor) {
        return this.execute(requestEntity, this.getRequestFactory(), this.getCookieHandler(), this.getRedirectManager(), responseExtractor);
    }

    public <T> HttpResponseEntity<T> execute(HttpRequestEntity<?> var1, ClientHttpRequestFactory var2, CookieHandler var3, RedirectManager var4, ClientHttpResponseExtractor<T> var5);

    default public <T> HttpResponseEntity<T> execute(HttpRequestEntity<?> requestEntity, ClientHttpRequestFactory requestFactory, CookieHandler cookieHandler, RedirectManager redirectManager, Class<? extends T> responseType) {
        return this.execute(requestEntity, requestFactory, cookieHandler, redirectManager, TypeDescriptor.valueOf(responseType));
    }

    public <T> HttpResponseEntity<T> execute(HttpRequestEntity<?> var1, ClientHttpRequestFactory var2, CookieHandler var3, RedirectManager var4, TypeDescriptor var5);

    default public <T> HttpResponseEntity<T> execute(HttpRequestEntity<?> requestEntity, Class<T> responseType) throws HttpClientException {
        return this.execute(requestEntity, TypeDescriptor.valueOf(responseType));
    }

    default public <T> HttpResponseEntity<T> execute(HttpRequestEntity<?> requestEntity, TypeDescriptor responseType) throws HttpClientException {
        return this.execute(requestEntity, this.getRequestFactory(), this.getCookieHandler(), this.getRedirectManager(), responseType);
    }

    default public <T> HttpResponseEntity<T> get(Class<T> responseType, String url) throws HttpClientException {
        return this.get(TypeDescriptor.valueOf(responseType), url);
    }

    default public <T> HttpResponseEntity<T> get(Class<T> responseType, URI uri) throws HttpClientException {
        return this.get(TypeDescriptor.valueOf(responseType), uri);
    }

    default public <T> HttpResponseEntity<T> get(TypeDescriptor responseType, String url) throws HttpClientException {
        return this.get(responseType, UriUtils.toUri(url));
    }

    default public <T> HttpResponseEntity<T> get(TypeDescriptor responseType, URI uri) throws HttpClientException {
        return this.execute(HttpRequestEntity.get(uri).build(), responseType);
    }

    default public <T> HttpResponseEntity<T> post(Class<T> responseType, URI uri, Object body, MediaType contentType) throws HttpClientException {
        return this.post(TypeDescriptor.valueOf(responseType), uri, body, contentType);
    }

    default public <T> HttpResponseEntity<T> post(Class<T> responseType, String url, Object body, MediaType contentType) throws HttpClientException {
        return this.post(TypeDescriptor.valueOf(responseType), UriUtils.toUri(url), body, contentType);
    }

    default public <T> HttpResponseEntity<T> post(TypeDescriptor responseType, String url, Object body, MediaType contentType) throws HttpClientException {
        return this.post(responseType, UriUtils.toUri(url), body, contentType);
    }

    default public <T> HttpResponseEntity<T> post(TypeDescriptor responseType, URI uri, Object body, MediaType contentType) throws HttpClientException {
        HttpRequestEntity.BodyBuilder<?> bodyBuilder = HttpRequestEntity.post(uri);
        if (contentType != null) {
            bodyBuilder = bodyBuilder.contentType(contentType);
        }
        return this.execute(bodyBuilder.body(body), responseType);
    }
}

