/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.http.HttpResponseEntity;
import io.basc.framework.http.client.AbstractHttpConnection;
import io.basc.framework.http.client.ClientHttpResponseExtractor;
import io.basc.framework.http.client.HttpClient;
import io.basc.framework.http.client.HttpClientException;
import java.net.URI;

public class HttpClientConnection
extends AbstractHttpConnection {
    private final HttpClient httpClient;

    public HttpClientConnection(URI uri, String httpMethod, HttpClient httpClient) {
        super(uri, httpMethod);
        this.setRequestFactory(httpClient.getRequestFactory());
        this.setCookieHandler(httpClient.getCookieHandler());
        this.setRedirectManager(httpClient.getRedirectManager());
        this.httpClient = httpClient;
    }

    protected HttpClientConnection(HttpClientConnection connection) {
        super(connection);
        this.httpClient = connection.httpClient;
    }

    @Override
    public <T> HttpResponseEntity<T> execute(ClientHttpResponseExtractor<T> responseExtractor) throws HttpClientException {
        return this.httpClient.execute(this.build(), this.getRequestFactory(), this.getCookieHandler(), this.getRedirectManager(), responseExtractor);
    }

    @Override
    public <T> HttpResponseEntity<T> execute(TypeDescriptor responseType) throws HttpClientException {
        return this.httpClient.execute(this.build(), this.getRequestFactory(), this.getCookieHandler(), this.getRedirectManager(), responseType);
    }

    @Override
    public HttpClientConnection clone() {
        return new HttpClientConnection(this);
    }
}

