/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.http.HttpRequest;
import io.basc.framework.http.HttpRequestEntity;
import io.basc.framework.http.HttpResponseEntity;
import io.basc.framework.http.MediaType;
import io.basc.framework.http.client.ClientHttpResponseExtractor;
import io.basc.framework.http.client.DownLoadResponseExtractor;
import io.basc.framework.http.client.HttpClientConfigurable;
import io.basc.framework.http.client.HttpClientException;
import io.basc.framework.lang.Nullable;
import io.basc.framework.net.MimeType;
import java.io.File;
import java.nio.charset.Charset;

public interface HttpConnection
extends HttpClientConfigurable<HttpConnection>,
HttpRequest,
HttpRequestEntity.HeadersBuilder<HttpConnection> {
    @Override
    public HttpConnection clone();

    public HttpConnection contentLength(long var1);

    public HttpConnection contentType(MediaType var1);

    default public HttpConnection contentType(MediaType contentType, Charset charset) {
        return this.contentType(new MediaType((MimeType)contentType, charset));
    }

    default public HttpConnection contentType(MediaType contentType, String charsetName) {
        return this.contentType(new MediaType((MimeType)contentType, charsetName));
    }

    default public HttpConnection body(Object body) {
        return this.body(body, null);
    }

    public HttpConnection body(Object var1, @Nullable TypeDescriptor var2);

    @Nullable
    public TypeDescriptor getTypeDescriptor();

    @Nullable
    public Object getBody();

    default public boolean hasBody() {
        return this.getBody() != null;
    }

    @Override
    default public <T> HttpRequestEntity<T> build() {
        return new HttpRequestEntity<Object>(this.getBody(), this.getHeaders(), this.getRawMethod(), this.getURI(), this.getTypeDescriptor());
    }

    public <T> HttpResponseEntity<T> execute(ClientHttpResponseExtractor<T> var1) throws HttpClientException;

    default public <T> HttpResponseEntity<T> execute(Class<T> responseType) throws HttpClientException {
        return this.execute(TypeDescriptor.valueOf(responseType));
    }

    public <T> HttpResponseEntity<T> execute(TypeDescriptor var1) throws HttpClientException;

    default public HttpResponseEntity<File> download() {
        return this.execute(DownLoadResponseExtractor.INSTANCE);
    }
}

