/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.http.HttpRequest;
import io.basc.framework.http.HttpStatus;
import io.basc.framework.http.client.ClientHttpResponse;
import io.basc.framework.http.client.ClientHttpResponseExtractor;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.net.message.convert.MessageConverter;
import java.io.IOException;

public class MessageConverterClientHttpResponseExtractor<T>
implements ClientHttpResponseExtractor<T> {
    private final MessageConverter messageConverter;
    private final TypeDescriptor responseType;

    public MessageConverterClientHttpResponseExtractor(MessageConverter messageConverter, TypeDescriptor responseType) {
        this.messageConverter = messageConverter;
        this.responseType = responseType;
    }

    @Override
    public T execute(HttpRequest request, ClientHttpResponse response) throws IOException {
        if (!request.getMethod().hasResponseBody()) {
            return null;
        }
        if (HttpStatus.OK.value() != response.getRawStatusCode()) {
            return null;
        }
        if (this.messageConverter == null || !this.messageConverter.canRead(this.responseType, response.getContentType())) {
            throw new UnsupportedException("not supported read responseType=" + this.responseType);
        }
        return (T)this.messageConverter.read(this.responseType, response);
    }
}

