/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.env.Sys;
import io.basc.framework.http.HttpMethod;
import io.basc.framework.http.client.ClientHttpRequest;
import io.basc.framework.http.client.ClientHttpRequestConfigAccessor;
import io.basc.framework.http.client.ClientHttpRequestFactory;
import io.basc.framework.http.client.SimpleBufferingClientHttpRequest;
import io.basc.framework.http.client.SimpleStreamingClientHttpRequest;
import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourceUtils;
import io.basc.framework.io.UnsafeByteArrayInputStream;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.net.ssl.SSLContexts;
import io.basc.framework.net.ssl.TrustAllManager;
import io.basc.framework.util.StringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SimpleClientHttpRequestFactory
extends ClientHttpRequestConfigAccessor
implements ClientHttpRequestFactory {
    private static Logger logger = LoggerFactory.getLogger(SimpleClientHttpRequestFactory.class);
    public static final SSLSocketFactory TRUSE_ALL_SSL_SOCKET_FACTORY;
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private Proxy proxy;
    private boolean bufferRequestBody = true;
    private int chunkSize = 4096;
    private boolean outputStreaming = true;
    private SSLSocketFactory sslSocketFactory = SimpleClientHttpRequestFactory.isTruseAll() ? TRUSE_ALL_SSL_SOCKET_FACTORY : null;

    public static void truseAll() {
        System.setProperty("io.basc.framework.http.truse.all.sll", "true");
    }

    public static boolean isTruseAll() {
        return Boolean.getBoolean("io.basc.framework.http.truse.all.sll");
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public boolean setSSLSocketFactory(String certTrustFile, String storePassword, String keyPassword) {
        if (StringUtils.isEmpty(certTrustFile)) {
            return false;
        }
        Resource resource = Sys.getEnv().getResourceLoader().getResource(certTrustFile);
        if (!resource.exists()) {
            logger.warn("not found certTrustFile: {}", certTrustFile);
            return false;
        }
        UnsafeByteArrayInputStream is = ResourceUtils.getInputStream(resource);
        try {
            this.sslSocketFactory = SSLContexts.custom().loadKeyMaterial(is, storePassword.toCharArray(), keyPassword.toCharArray()).build().getSocketFactory();
        }
        catch (Exception e) {
            logger.error(e, "certTrustFile [{}], storePassword [{}], keyPassword [{}]", certTrustFile, storePassword, keyPassword);
            return false;
        }
        return true;
    }

    public void setBufferRequestBody(boolean bufferRequestBody) {
        this.bufferRequestBody = bufferRequestBody;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setOutputStreaming(boolean outputStreaming) {
        this.outputStreaming = outputStreaming;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, String httpMethod) throws IOException {
        HttpURLConnection connection = this.openConnection(uri.toURL(), this.proxy);
        try {
            this.prepareConnection(connection, httpMethod);
        }
        catch (Throwable e) {
            connection.disconnect();
            throw e;
        }
        if (this.bufferRequestBody) {
            return new SimpleBufferingClientHttpRequest(connection, this.outputStreaming);
        }
        return new SimpleStreamingClientHttpRequest(connection, this.chunkSize, this.outputStreaming);
    }

    protected HttpURLConnection openConnection(URL url, Proxy proxy) throws IOException {
        URLConnection urlConnection;
        URLConnection uRLConnection = urlConnection = proxy != null ? url.openConnection(proxy) : url.openConnection();
        if (!HttpURLConnection.class.isInstance(urlConnection)) {
            throw new IllegalStateException("HttpURLConnection required for [" + url + "] but got: " + urlConnection);
        }
        return (HttpURLConnection)urlConnection;
    }

    protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
        SSLSocketFactory factory;
        Integer readTimeout;
        Integer connectTimeout = this.getConnectTimeout();
        if (connectTimeout != null && connectTimeout >= 0) {
            connection.setConnectTimeout(connectTimeout);
        }
        if ((readTimeout = Integer.valueOf(this.getReadTimeout())) != null && readTimeout >= 0) {
            connection.setReadTimeout(readTimeout);
        }
        connection.setRequestMethod(httpMethod);
        if ("GET".equals(httpMethod)) {
            connection.setInstanceFollowRedirects(true);
        } else {
            connection.setInstanceFollowRedirects(false);
        }
        connection.setDoInput(HttpMethod.hasResponseBody(httpMethod));
        connection.setDoOutput(HttpMethod.hasRequestBody(httpMethod));
        if (connection instanceof HttpsURLConnection && (factory = this.getSslSocketFactory()) != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(factory);
        }
    }

    static {
        TrustManager[] trustAllCerts = new TrustManager[1];
        TrustAllManager tm = new TrustAllManager();
        trustAllCerts[0] = tm;
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
        }
        catch (Throwable e) {
            logger.error(e, "Initialize ssl exception");
        }
        TRUSE_ALL_SSL_SOCKET_FACTORY = sc == null ? null : sc.getSocketFactory();
    }
}

