/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.Bits;
import io.basc.framework.util.Assert;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Bytes {
    private Bytes() {
    }

    public static byte[] copyOf(byte[] src, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(src, 0, dest, 0, Math.min(src.length, length));
        return dest;
    }

    public static List<byte[]> string2byteList(Collection<String> strings) {
        if (strings == null) {
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>(strings.size());
        for (String v : strings) {
            if (v == null) {
                list.add(null);
                continue;
            }
            list.add(Bytes.string2bytes(v));
        }
        return list;
    }

    public static byte[][] string2bytes(Collection<String> strings) {
        if (strings == null) {
            return null;
        }
        byte[][] bs = new byte[strings.size()][];
        int i = 0;
        for (String v : strings) {
            bs[i++] = Bytes.string2bytes(v);
        }
        return bs;
    }

    public static byte[] string2bytes(String string) {
        if (string == null) {
            return null;
        }
        int size = string.length();
        byte[] bytes = new byte[size * 2];
        int i = 0;
        int b = 0;
        while (i < size) {
            Bits.putChar(bytes, b, string.charAt(i));
            ++i;
            b += 2;
        }
        return bytes;
    }

    public static String bytes2String(byte[] b) {
        if (b == null) {
            return null;
        }
        return new String(Bytes.bytes2chars(b));
    }

    public static byte[][] string2bytes(String ... strings) {
        if (strings == null) {
            return null;
        }
        byte[][] bs = new byte[strings.length][];
        for (int i = 0; i < strings.length; ++i) {
            bs[i] = Bytes.string2bytes(strings[i]);
        }
        return bs;
    }

    public static byte[] short2bytes(short v) {
        byte[] ret = new byte[]{0, 0};
        Bytes.short2bytes(v, ret);
        return ret;
    }

    public static void short2bytes(short v, byte[] b) {
        Bytes.short2bytes(v, b, 0);
    }

    public static void short2bytes(short v, byte[] b, int off) {
        b[off + 1] = (byte)v;
        b[off + 0] = (byte)(v >>> 8);
    }

    public static byte[] int2bytes(int v) {
        byte[] ret = new byte[]{0, 0, 0, 0};
        Bytes.int2bytes(v, ret);
        return ret;
    }

    public static void int2bytes(int v, byte[] b) {
        Bytes.int2bytes(v, b, 0);
    }

    public static void int2bytes(int v, byte[] b, int off) {
        b[off + 3] = (byte)v;
        b[off + 2] = (byte)(v >>> 8);
        b[off + 1] = (byte)(v >>> 16);
        b[off + 0] = (byte)(v >>> 24);
    }

    public static byte[] float2bytes(float v) {
        byte[] ret = new byte[]{0, 0, 0, 0};
        Bytes.float2bytes(v, ret);
        return ret;
    }

    public static void float2bytes(float v, byte[] b) {
        Bytes.float2bytes(v, b, 0);
    }

    public static void float2bytes(float v, byte[] b, int off) {
        int i = Float.floatToIntBits(v);
        b[off + 3] = (byte)i;
        b[off + 2] = (byte)(i >>> 8);
        b[off + 1] = (byte)(i >>> 16);
        b[off + 0] = (byte)(i >>> 24);
    }

    public static byte[] long2bytes(long v) {
        byte[] ret = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        Bytes.long2bytes(v, ret);
        return ret;
    }

    public static void long2bytes(long v, byte[] b) {
        Bytes.long2bytes(v, b, 0);
    }

    public static void long2bytes(long v, byte[] b, int off) {
        b[off + 7] = (byte)v;
        b[off + 6] = (byte)(v >>> 8);
        b[off + 5] = (byte)(v >>> 16);
        b[off + 4] = (byte)(v >>> 24);
        b[off + 3] = (byte)(v >>> 32);
        b[off + 2] = (byte)(v >>> 40);
        b[off + 1] = (byte)(v >>> 48);
        b[off + 0] = (byte)(v >>> 56);
    }

    public static byte[] double2bytes(double v) {
        byte[] ret = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        Bytes.double2bytes(v, ret);
        return ret;
    }

    public static void double2bytes(double v, byte[] b) {
        Bytes.double2bytes(v, b, 0);
    }

    public static void double2bytes(double v, byte[] b, int off) {
        long j = Double.doubleToLongBits(v);
        b[off + 7] = (byte)j;
        b[off + 6] = (byte)(j >>> 8);
        b[off + 5] = (byte)(j >>> 16);
        b[off + 4] = (byte)(j >>> 24);
        b[off + 3] = (byte)(j >>> 32);
        b[off + 2] = (byte)(j >>> 40);
        b[off + 1] = (byte)(j >>> 48);
        b[off + 0] = (byte)(j >>> 56);
    }

    public static short bytes2short(byte[] b) {
        return Bytes.bytes2short(b, 0);
    }

    public static short bytes2short(byte[] b, int off) {
        return (short)(((b[off + 1] & 0xFF) << 0) + (b[off + 0] << 8));
    }

    public static int bytes2int(byte[] b) {
        return Bytes.bytes2int(b, 0);
    }

    public static int bytes2int(byte[] b, int off) {
        return ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + (b[off + 0] << 24);
    }

    public static float bytes2float(byte[] b) {
        return Bytes.bytes2float(b, 0);
    }

    public static float bytes2float(byte[] b, int off) {
        int i = ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + (b[off + 0] << 24);
        return Float.intBitsToFloat(i);
    }

    public static long bytes2long(byte[] b) {
        return Bytes.bytes2long(b, 0);
    }

    public static long bytes2long(byte[] b, int off) {
        return (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + ((long)b[off + 0] << 56);
    }

    public static double bytes2double(byte[] b) {
        return Bytes.bytes2double(b, 0);
    }

    public static double bytes2double(byte[] b, int off) {
        long j = (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + ((long)b[off + 0] << 56);
        return Double.longBitsToDouble(j);
    }

    public static char[] bytes2chars(byte[] b) {
        if ((b.length & 1) != 0) {
            throw new IllegalArgumentException("\u4e00\u4e2achar\u5360\u7528\u4e24\u4e2abyte\uff0c\u6240\u4ee5\u8f93\u5165\u7684byte\u6570\u7ec4\u957f\u5ea6\u5fc5\u987b\u662f\u4e00\u4e2a\u5076\u6570");
        }
        char[] chars = new char[b.length >> 1];
        int i = 0;
        int index = 0;
        while (i < b.length) {
            chars[index] = Bits.getChar(b, i);
            i += 2;
            ++index;
        }
        return chars;
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        Assert.notNull((Object)byteBuffer, "ByteBuffer must not be null!");
        ByteBuffer duplicate = byteBuffer.duplicate();
        byte[] bytes = new byte[duplicate.remaining()];
        duplicate.get(bytes);
        return bytes;
    }
}

