/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.AbstractFileResolvingResource;
import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourceUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ClassPathResource
extends AbstractFileResolvingResource {
    private final String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        Assert.notNull((Object)path, "Path must not be null");
        String pathToUse = StringUtils.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassPathResource(String path, Class<?> clazz) {
        Assert.notNull((Object)path, "Path must not be null");
        this.path = StringUtils.cleanPath(path);
        this.clazz = clazz;
    }

    protected ClassPathResource(String path, ClassLoader classLoader, Class<?> clazz) {
        this.path = StringUtils.cleanPath(path);
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.path;
    }

    public final ClassLoader getClassLoader() {
        return this.clazz != null ? this.clazz.getClassLoader() : this.classLoader;
    }

    @Override
    public boolean exists() {
        return this.resolveURL() != null;
    }

    protected URL resolveURL() {
        URL url = ResourceUtils.getResource(this.clazz, this.path);
        if (url == null) {
            url = ResourceUtils.getResource(this.getClassLoader(), this.path);
        }
        if (url == null) {
            url = ResourceUtils.getSystemResource(ClassUtils.getDefaultClassLoader(), this.path);
        }
        return url;
    }

    protected URL resolveURLInternal(String path) {
        URL url = null;
        if (this.clazz != null) {
            url = this.clazz.getResource(path);
        }
        if (url == null && this.classLoader != null) {
            url = this.classLoader.getResource(path);
        }
        if (url == null) {
            url = ClassUtils.getDefaultClassLoader().getResource(path);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(path);
        }
        return url;
    }

    protected InputStream getInputStreamInternal(String path) throws IOException {
        InputStream is = null;
        if (this.clazz != null) {
            is = this.clazz.getResourceAsStream(path);
        }
        if (is == null && this.classLoader != null) {
            is = this.classLoader.getResourceAsStream(path);
        }
        if (is == null) {
            is = ClassUtils.getDefaultClassLoader().getResourceAsStream(path);
        }
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(path);
        }
        return is;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = ResourceUtils.getResourceAsStream(this.clazz, this.path);
        if (is == null) {
            is = ResourceUtils.getResourceAsStream(this.getClassLoader(), this.path);
        }
        if (is == null) {
            is = ResourceUtils.getSystemResourceAsStream(ClassUtils.getDefaultClassLoader(), this.path);
        }
        if (is == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.resolveURL();
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = StringUtils.applyRelativePath(this.path, relativePath);
        return this.clazz != null ? new ClassPathResource(pathToUse, this.clazz) : new ClassPathResource(pathToUse, this.classLoader);
    }

    @Override
    public String getName() {
        return StringUtils.getFilename(this.path);
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder("class path resource [");
        String pathToUse = this.path;
        if (this.clazz != null && !pathToUse.startsWith("/")) {
            builder.append(ClassUtils.classPackageAsResourcePath(this.clazz));
            builder.append('/');
        }
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        builder.append(pathToUse);
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClassPathResource) {
            ClassPathResource otherRes = (ClassPathResource)obj;
            return this.path.equals(otherRes.path) && ObjectUtils.equals(this.classLoader, otherRes.classLoader) && ObjectUtils.equals(this.clazz, otherRes.clazz);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }
}

