/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.io.ClassPathResource;
import io.basc.framework.io.ConfigurableResourceLoader;
import io.basc.framework.io.ContextResource;
import io.basc.framework.io.FileUrlResource;
import io.basc.framework.io.ProtocolResolver;
import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourceLoader;
import io.basc.framework.io.ResourceUtils;
import io.basc.framework.io.UrlResource;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassLoaderProvider;
import io.basc.framework.util.DefaultClassLoaderProvider;
import io.basc.framework.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultResourceLoader
extends DefaultClassLoaderProvider
implements ConfigurableResourceLoader,
Configurable {
    private final ConfigurableServices<ProtocolResolver> protocolResolvers = new ConfigurableServices<ProtocolResolver>(ProtocolResolver.class);
    private final ConfigurableServices<ResourceLoader> resourceLoaders = new ConfigurableServices<ResourceLoader>(ResourceLoader.class);
    private boolean configured;

    public DefaultResourceLoader() {
    }

    public DefaultResourceLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public DefaultResourceLoader(ClassLoaderProvider classLoaderProvider) {
        super(classLoaderProvider);
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        this.protocolResolvers.configure(serviceLoaderFactory);
        this.resourceLoaders.configure(serviceLoaderFactory);
        this.configured = true;
    }

    @Override
    public ConfigurableServices<ProtocolResolver> getProtocolResolvers() {
        return this.protocolResolvers;
    }

    @Override
    public ConfigurableServices<ResourceLoader> getResourceLoaders() {
        return this.resourceLoaders;
    }

    @Override
    public Resource getResource(String location) {
        Resource resource;
        Assert.notNull((Object)location, "Location must not be null");
        for (ProtocolResolver protocolResolver : this.getProtocolResolvers()) {
            resource = protocolResolver.resolve(location, this);
            if (resource == null) continue;
            return resource;
        }
        for (ResourceLoader resourceLoader : this.getResourceLoaders()) {
            resource = resourceLoader.getResource(location);
            if (resource == null) continue;
            return resource;
        }
        if (location.startsWith("/")) {
            return this.getResourceByPath(location);
        }
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()), this.getClassLoader());
        }
        try {
            URL url = new URL(location);
            return ResourceUtils.isFileURL(url) ? new FileUrlResource(url) : new UrlResource(url);
        }
        catch (MalformedURLException ex) {
            return this.getResourceByPath(location);
        }
    }

    protected Resource getResourceByPath(String path) {
        return new ClassPathContextResource(path, this.getClassLoader());
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }

    protected static class ClassPathContextResource
    extends ClassPathResource
    implements ContextResource {
        public ClassPathContextResource(String path, ClassLoader classLoader) {
            super(path, classLoader);
        }

        @Override
        public String getPathWithinContext() {
            return this.getPath();
        }

        @Override
        public Resource createRelative(String relativePath) {
            String pathToUse = StringUtils.applyRelativePath(this.getPath(), relativePath);
            return new ClassPathContextResource(pathToUse, this.getClassLoader());
        }
    }
}

