/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.core.type.classreading.CachingMetadataReaderFactory;
import io.basc.framework.io.DefaultResourceLoader;
import io.basc.framework.io.FileSystemResource;
import io.basc.framework.io.FileSystemResourceLoader;
import io.basc.framework.io.FileUtils;
import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourceLoader;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.ResourceClassesLoader;
import java.io.File;
import java.util.stream.Stream;

public class DirectoryClassesLoader
extends ResourceClassesLoader {
    public DirectoryClassesLoader(File directory) {
        this(directory, (ResourceLoader)new FileSystemResourceLoader());
    }

    public DirectoryClassesLoader(File directory, ResourceLoader resourceLoader) {
        super(() -> {
            Stream<Resource> stream = FileUtils.stream(directory, f -> f.getName().endsWith(".class")).map((? super T f) -> new FileSystemResource((File)f.getFile()));
            return Cursor.of(stream);
        });
        Assert.requiredArgument(resourceLoader != null, "resourceLoader");
        DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
        defaultResourceLoader.getResourceLoaders().addService(resourceLoader);
        this.setMetadataReaderFactory(new CachingMetadataReaderFactory(defaultResourceLoader));
    }

    public DirectoryClassesLoader(String directory) {
        this(new File(directory));
    }

    public DirectoryClassesLoader(String directory, ResourceLoader resourceLoader) {
        this(new File(directory), resourceLoader);
    }
}

