/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.core.type.classreading.CachingMetadataReaderFactory;
import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourcePatternResolver;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.ResourceClassesLoader;
import io.basc.framework.util.StaticSupplier;
import java.io.IOException;
import java.util.function.Supplier;

public class LocationPatternClassesLoader
extends ResourceClassesLoader {
    private static Logger logger = LoggerFactory.getLogger(LocationPatternClassesLoader.class);

    public LocationPatternClassesLoader(ResourcePatternResolver resourcePatternResolver, String locationPattern) {
        this(resourcePatternResolver, new StaticSupplier<String>(locationPattern));
    }

    public LocationPatternClassesLoader(ResourcePatternResolver resourcePatternResolver, Supplier<String> locationPatternSupplier) {
        super(() -> {
            String location = (String)locationPatternSupplier.get();
            if (location == null) {
                return Cursor.empty();
            }
            Resource[] resources = null;
            try {
                resources = resourcePatternResolver.getResources(location);
            }
            catch (IOException e) {
                logger.error(e, "Failed to obtain {} to obtain resources", location);
            }
            if (resources == null || resources.length == 0) {
                return Cursor.empty();
            }
            return Cursor.of(resources);
        });
        this.setMetadataReaderFactory(new CachingMetadataReaderFactory(resourcePatternResolver));
    }
}

