/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Processor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public interface OutputStreamSource {
    public OutputStream getOutputStream() throws IOException;

    default public WritableByteChannel writableChannel() throws IOException {
        return Channels.newChannel(this.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, E extends Throwable> T write(Processor<? super OutputStream, ? extends T, ? extends E> processor) throws IOException, E {
        try (OutputStream os = null;){
            os = this.getOutputStream();
            T t = processor.process(os);
            return t;
        }
    }

    default public <E extends Throwable> void produce(ConsumeProcessor<? super OutputStream, ? extends E> processor) throws IOException, E {
        this.write(is -> {
            processor.process((OutputStream)is);
            return null;
        });
    }
}

