/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.support.SerializerCodec;
import io.basc.framework.codec.support.ToBytesCodec;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.io.CrossLanguageSerializer;
import io.basc.framework.io.SerializerException;
import io.basc.framework.io.UnsafeByteArrayInputStream;
import io.basc.framework.io.UnsafeByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface Serializer
extends ToBytesCodec<Object>,
CrossLanguageSerializer {
    public void serialize(Object var1, OutputStream var2) throws IOException;

    @Override
    default public void serialize(Object source, TypeDescriptor sourceTypeDescriptor, OutputStream target) throws IOException {
        this.serialize(source, target);
    }

    @Override
    default public <T> T deserialize(InputStream source, TypeDescriptor targetTypeDescriptor) throws IOException, DecodeException {
        try {
            return this.deserialize(source);
        }
        catch (ClassNotFoundException e) {
            throw new DecodeException(e);
        }
    }

    @Override
    default public void encode(Object source, OutputStream target) throws IOException, EncodeException {
        this.serialize(source, target);
    }

    default public byte[] serialize(Object data) throws SerializerException {
        try (UnsafeByteArrayOutputStream target = new UnsafeByteArrayOutputStream();){
            this.serialize(data, target);
            byte[] byArray = target.toByteArray();
            return byArray;
        }
    }

    public <T> T deserialize(InputStream var1, int var2) throws IOException, ClassNotFoundException;

    default public <T> T deserialize(InputStream input) throws IOException, ClassNotFoundException {
        return this.deserialize(input, 4096);
    }

    default public <T> T deserialize(byte[] data) throws ClassNotFoundException, SerializerException {
        try (UnsafeByteArrayInputStream input = new UnsafeByteArrayInputStream(data);){
            T t = this.deserialize(input);
            return t;
        }
    }

    @Override
    default public byte[] encode(Object source) throws EncodeException {
        return this.serialize(source);
    }

    @Override
    default public Object decode(InputStream source, int bufferSize) throws IOException, DecodeException {
        try {
            return this.deserialize(source, bufferSize);
        }
        catch (ClassNotFoundException e) {
            throw new DecodeException(e);
        }
    }

    default public <D> Codec<D, byte[]> toCodec() {
        return new SerializerCodec(this);
    }
}

