/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.event.ChangeType;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.io.AbstractResource;
import io.basc.framework.io.Resource;
import io.basc.framework.io.SimpleResourceEventDispatcher;
import io.basc.framework.lang.RequiredJavaVersion;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiredJavaVersion(value=7)
public class WatchServiceResourceEventDispatcher
extends SimpleResourceEventDispatcher {
    private static Logger logger = LoggerFactory.getLogger(WatchServiceResourceEventDispatcher.class);
    private static final WatchService WATCH_SERVICE;
    private static ConcurrentHashMap<Path, ResourceWatchKey> listenerMap;
    private AtomicBoolean registred = new AtomicBoolean();

    public WatchServiceResourceEventDispatcher(AbstractResource resource) {
        super(resource);
    }

    public WatchServiceResourceEventDispatcher(AbstractResource resource, long listenerPeriod) {
        super(resource, listenerPeriod);
    }

    private boolean watchServiceRegister() {
        if (WATCH_SERVICE == null) {
            return false;
        }
        if (!this.registred.get() && this.registred.compareAndSet(false, true)) {
            try {
                File file = this.getResource().getFile();
                if (file.isDirectory() || file.getParentFile() == null) {
                    return false;
                }
                Path path = file.getParentFile().toPath();
                ResourceWatchKey resourceWatchKey = listenerMap.get(path);
                if (resourceWatchKey == null) {
                    resourceWatchKey = new ResourceWatchKey();
                    ResourceWatchKey old = listenerMap.putIfAbsent(path, resourceWatchKey);
                    if (old != null) {
                        resourceWatchKey = old;
                    } else {
                        WatchKey watchKey = path.register(WATCH_SERVICE, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                        resourceWatchKey.setWatchKey(watchKey);
                    }
                }
                resourceWatchKey.register(file, this.getResource());
                return true;
            }
            catch (IOException e) {
                this.registred.compareAndSet(true, false);
                return false;
            }
        }
        return false;
    }

    @Override
    public void publishEvent(ObservableChangeEvent<Resource> event) {
        if (event.getChangeType() == ChangeType.CREATE && this.watchServiceRegister()) {
            this.cancelListener();
        }
        super.publishEvent(event);
    }

    @Override
    protected void listener() {
        if (this.watchServiceRegister()) {
            return;
        }
        super.listener();
    }

    static {
        WatchService watchService = null;
        try {
            watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            logger.error(e, "\u65e0\u6cd5\u521b\u5efaWatchService");
        }
        WATCH_SERVICE = watchService;
        if (WATCH_SERVICE != null) {
            listenerMap = new ConcurrentHashMap();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            WATCH_SERVICE.take();
                            for (ResourceWatchKey key : listenerMap.values()) {
                                key.run();
                            }
                        }
                        catch (Throwable e) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.setName(WatchServiceResourceEventDispatcher.class.getSimpleName());
            thread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        WATCH_SERVICE.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    super.run();
                }
            });
        }
    }

    private static class ResourceWatchKey
    implements Runnable {
        private WatchKey watchKey;
        private final Set<ResourceItem> resources = new CopyOnWriteArraySet<ResourceItem>();

        private ResourceWatchKey() {
        }

        public void register(File file, AbstractResource resource) {
            this.resources.add(new ResourceItem(file.getName(), resource));
        }

        public void setWatchKey(WatchKey watchKey) {
            this.watchKey = watchKey;
        }

        @Override
        public void run() {
            if (this.watchKey == null || !this.watchKey.isValid()) {
                return;
            }
            List<WatchEvent<?>> watchEvents = this.watchKey.pollEvents();
            try {
                for (WatchEvent<?> event : watchEvents) {
                    Path path;
                    File file;
                    Object context = event.context();
                    if (context == null || !(context instanceof Path) || (file = (path = (Path)context).toFile()) == null) continue;
                    ChangeType eventType = null;
                    if (StandardWatchEventKinds.ENTRY_CREATE.equals(event.kind())) {
                        eventType = ChangeType.CREATE;
                    } else if (StandardWatchEventKinds.ENTRY_MODIFY.equals(event.kind())) {
                        eventType = ChangeType.UPDATE;
                    } else if (StandardWatchEventKinds.ENTRY_DELETE.equals(event.kind())) {
                        eventType = ChangeType.DELETE;
                    }
                    if (eventType == null) continue;
                    for (ResourceItem item : this.resources) {
                        if (!file.getName().equals(item.getName())) continue;
                        ObservableChangeEvent<Resource> resourceEvent = new ObservableChangeEvent<Resource>(eventType, item.getResource(), item.getResource());
                        if (logger.isDebugEnabled()) {
                            logger.debug(resourceEvent.toString());
                        }
                        try {
                            item.getResource().publishEvent(resourceEvent);
                        }
                        catch (Throwable e) {
                            logger.error(e, item.getResource().getDescription());
                        }
                    }
                }
            }
            catch (Throwable e) {
                logger.error(e, this.watchKey.toString());
            }
            this.watchKey.reset();
        }
    }

    private static final class ResourceItem {
        private final String name;
        private final AbstractResource resource;

        public ResourceItem(String name, AbstractResource resource) {
            this.name = name;
            this.resource = resource;
        }

        public String getName() {
            return this.name;
        }

        public AbstractResource getResource() {
            return this.resource;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof ResourceItem) {
                return ((ResourceItem)obj).resource == this.resource;
            }
            return false;
        }

        public int hashCode() {
            return this.resource.hashCode();
        }
    }
}

